/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import cn.hutool.core.convert.Convert;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.order.UocOrderRelUpdateService;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateReqBo;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocOrderRelUpdateService.class)
public class UocOrderRelUpdateServiceImpl
implements UocOrderRelUpdateService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    public UocOrderRelUpdateRspBo dealRelUpdate(UocOrderRelUpdateReqBo reqBo) {
        this.validateArg(reqBo);
        UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
        uocOrderRelQryBo.setObjId(reqBo.getObjId());
        uocOrderRelQryBo.setObjType(reqBo.getObjType());
        uocOrderRelQryBo.setRelType(reqBo.getRelType());
        UocOrderRel qryRelInfo = this.iUocOrderModel.qryRelInfo(uocOrderRelQryBo);
        UocOrderRel uocOrderRel = new UocOrderRel();
        if (null != qryRelInfo) {
            uocOrderRel.setId(qryRelInfo.getId());
            uocOrderRel.setRelStatus(reqBo.getRelState());
            uocOrderRel.setRelId(reqBo.getRelId());
            this.iUocOrderModel.dealRelUpdate(uocOrderRel);
        } else {
            uocOrderRel = UocRu.js(reqBo, UocOrderRel.class);
            uocOrderRel.setRelStatus(reqBo.getRelState());
            uocOrderRel.setId(IdUtil.nextId());
            this.iUocOrderModel.createRelInfo(uocOrderRel);
        }
        uocOrderRel.setRelType(reqBo.getRelType());
        uocOrderRel.setObjId(reqBo.getObjId());
        uocOrderRel.setObjType(reqBo.getObjType());
        this.syncEs(uocOrderRel, reqBo);
        return UocRu.success(UocOrderRelUpdateRspBo.class);
    }

    private void validateArg(UocOrderRelUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e0d\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException("100001", "ObjId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException("100001", "ObjType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getRelState()) {
            throw new BaseBusinessException("100001", "relState\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getRelType()) {
            throw new BaseBusinessException("100001", "relType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_ORDER_REL_TYPE");
        pCodes.add("UOC_ORDER_REL_STATUS");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private void syncEs(UocOrderRel uocOrderRel, UocOrderRelUpdateReqBo reqBo) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderRel.getObjId());
        if (UocDicConstant.REL_TYPE.SERVICE_CHARGE.equals(uocOrderRel.getRelType())) {
            this.calTransactionRel(uocOrderRel, uocEsSyncManagerSaveDataReqBo);
        } else {
            List<UocOrderRel> uocOrderRelList = this.getUocRelInfo(reqBo);
            this.calOrderBillRel(uocOrderRelList, uocEsSyncManagerSaveDataReqBo, reqBo);
        }
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    private void calOrderBillRel(List<UocOrderRel> uocOrderRelList, UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo, UocOrderRelUpdateReqBo reqBo) {
        if (uocOrderRelList.size() == 1 && (UocDicConstant.REL_TYPE.UP_INVOICE.equals(uocOrderRelList.get(0).getRelType()) || UocDicConstant.REL_TYPE.COMMON_INVOICE.equals(uocOrderRelList.get(0).getRelType()))) {
            UocOrderRel uocOrderRel = new UocOrderRel();
            uocOrderRel.setOrderId(reqBo.getOrderId());
            uocOrderRel.setRelType(UocDicConstant.REL_TYPE.UP_INVOICE.equals(uocOrderRelList.get(0).getRelType()) ? UocDicConstant.REL_TYPE.COMMON_INVOICE : UocDicConstant.REL_TYPE.UP_INVOICE);
            uocOrderRel.setObjId(reqBo.getObjId());
            uocOrderRel.setObjType(reqBo.getObjType());
            uocOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
            uocOrderRelList.add(uocOrderRel);
        }
        JSONObject jsonObj = new JSONObject();
        ArrayList<Integer> relTypes = new ArrayList<Integer>();
        ArrayList<String> relInfo = new ArrayList<String>();
        ArrayList<String> relIds = new ArrayList<String>();
        Map<String, Map<String, String>> dic = this.getDic();
        Map<String, String> relTypeMap = dic.get("UOC_ORDER_REL_TYPE");
        Map<String, String> relStatusMap = dic.get("UOC_ORDER_REL_STATUS");
        for (UocOrderRel uocOrderRel : uocOrderRelList) {
            if (!StringUtils.isBlank((CharSequence)uocOrderRel.getRelId())) {
                relIds.add(uocOrderRel.getRelId());
            }
            relTypes.add(uocOrderRel.getRelType());
            relInfo.add(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType());
            uocOrderRel.setRelStatusStr(relStatusMap.get(Convert.toStr((Object)uocOrderRel.getRelStatus())));
            uocOrderRel.setRelTypeStr(relTypeMap.get(Convert.toStr((Object)uocOrderRel.getRelType())));
        }
        jsonObj.put("relType", relTypes);
        jsonObj.put("relInfo", relInfo);
        jsonObj.put("relId", relIds);
        jsonObj.put("fscRelInfoBos", uocOrderRelList);
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
    }

    private void calTransactionRel(UocOrderRel uocOrderRel, UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("relType", (Object)uocOrderRel.getRelType());
        jsonObj.put("relStatus", (Object)uocOrderRel.getRelStatus());
        jsonObj.put("relInfo", (Object)(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType()));
        jsonObj.put("relId", (Object)uocOrderRel.getRelId());
        Map<String, Map<String, String>> dic = this.getDic();
        Map<String, String> relTypeMap = dic.get("UOC_ORDER_REL_TYPE");
        Map<String, String> relStatusMap = dic.get("UOC_ORDER_REL_STATUS");
        jsonObj.put("relStatusStr", (Object)relStatusMap.get(Convert.toStr((Object)uocOrderRel.getRelStatus())));
        jsonObj.put("relTypeStr", (Object)relTypeMap.get(Convert.toStr((Object)uocOrderRel.getRelType())));
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getTransactionIndex());
    }

    private List<UocOrderRel> getUocRelInfo(UocOrderRelUpdateReqBo reqBo) {
        UocOrderRelQryBo qryBo = new UocOrderRelQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setObjId(reqBo.getObjId());
        qryBo.setObjType(reqBo.getObjType());
        ArrayList<Integer> relType = new ArrayList<Integer>();
        relType.add(UocDicConstant.REL_TYPE.UP_INVOICE);
        relType.add(UocDicConstant.REL_TYPE.COMMON_INVOICE);
        relType.add(UocDicConstant.REL_TYPE.CH_INVOICE);
        qryBo.setRelTypeList(relType);
        List<UocOrderRel> uocOrderRels = this.iUocOrderModel.qryListRelInfo(qryBo);
        if (CollectionUtils.isEmpty(uocOrderRels)) {
            throw new BaseBusinessException("100001", "\u83b7\u53d6\u7ed3\u7b97\u8ba2\u5355\u5173\u8054\u5173\u7cfb\u4e3a\u7a7a");
        }
        return uocOrderRels;
    }
}

