/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.service.order.UocProOrderEffectivePageQueryService;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocProOrderEffectivePageQueryService.class)
public class UocProOrderEffectivePageQueryServiceImpl
implements UocProOrderEffectivePageQueryService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    public UocProOrderEffectiveListPageQueryRspBo queryOrderEffectiveListPage(UocProOrderEffectiveListPageQueryReqBo reqBo) {
        UocProOrderEffectiveListPageQueryRspBo rspBo = UocRu.success(UocProOrderEffectiveListPageQueryRspBo.class);
        rspBo.setPageNo(reqBo.getPageNo());
        UocConfEffectiveQryBo effectivePOWhere = new UocConfEffectiveQryBo();
        Map<String, String> effectiveNameMap = null;
        if (null != reqBo.getEffectiveId() && 0L != reqBo.getEffectiveId()) {
            effectivePOWhere.setEffectiveId(reqBo.getEffectiveId());
        } else {
            if (StringUtils.hasText((String)reqBo.getEffectiveName())) {
                List<UocSysDictionaryDo> effectiveCodes = this.getEffectiveCodeListByEffectiveName();
                if (CollectionUtils.isEmpty(effectiveCodes)) {
                    rspBo.setTotal(0);
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList(0));
                    return rspBo;
                }
                effectiveNameMap = new HashMap<String, String>(effectiveCodes.size());
                ArrayList<String> effectiveCodeList = new ArrayList<String>();
                for (UocSysDictionaryDo dicDictionaryBO : effectiveCodes) {
                    if (null == dicDictionaryBO.getDescrip() || !dicDictionaryBO.getDescrip().contains(reqBo.getEffectiveName())) continue;
                    effectiveCodeList.add(dicDictionaryBO.getCode());
                    effectiveNameMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                }
                if (CollectionUtils.isEmpty(effectiveCodeList)) {
                    rspBo.setTotal(0);
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList(0));
                    return rspBo;
                }
                effectivePOWhere.setEffectiveCodeList(effectiveCodeList);
            }
            effectivePOWhere.setBusinessTypeCode(reqBo.getBusinessTypeCode());
            effectivePOWhere.setSupplierNo(reqBo.getSupplierNo());
            effectivePOWhere.setSourceCode(reqBo.getSourceCode());
            effectivePOWhere.setOperatingTimeStart(DateUtils.strToDateLong((String)reqBo.getOperatingTimeStart()));
            effectivePOWhere.setOperatingTimeEnd(DateUtils.strToDateLong((String)reqBo.getOperatingTimeEnd()));
            effectivePOWhere.setOperatorName(reqBo.getOperatorName());
            effectivePOWhere.setEffectiveCode(reqBo.getEffectiveCode());
        }
        effectivePOWhere.setOrderBy("effective_code, source_code,case business_type_code when '2' then 1 when '1' then 2 else 3 end");
        effectivePOWhere.setPageNo(reqBo.getPageNo());
        effectivePOWhere.setPageSize(reqBo.getPageSize());
        BasePageRspBo<UocConfEffective> uocConfEffectiveBasePageRspBo = this.iUocOrderModel.qryListPageConfEffective(effectivePOWhere);
        if (CollectionUtils.isEmpty((Collection)uocConfEffectiveBasePageRspBo.getRows())) {
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList(0));
        } else {
            rspBo.setTotal(uocConfEffectiveBasePageRspBo.getTotal());
            rspBo.setRecordsTotal(uocConfEffectiveBasePageRspBo.getRecordsTotal());
            ArrayList<UocProOrderEffectiveInfoBo> rows = new ArrayList<UocProOrderEffectiveInfoBo>(uocConfEffectiveBasePageRspBo.getRows().size());
            Map<String, Map<String, String>> dicValName = this.getDicValName(effectiveNameMap);
            effectiveNameMap = dicValName.get("EFFECTIVE_CODE");
            Map<String, String> businessTypeMap = dicValName.get("UOC_SALE_ORDER_SOURCE");
            Map<String, String> sourceNameMap = dicValName.get("SOURCE_CODE");
            for (UocConfEffective effectivePO : uocConfEffectiveBasePageRspBo.getRows()) {
                UocProOrderEffectiveInfoBo orderEffectiveInfoBo = new UocProOrderEffectiveInfoBo();
                orderEffectiveInfoBo.setEffectiveId(effectivePO.getEffectiveId());
                orderEffectiveInfoBo.setEffectiveCode(effectivePO.getEffectiveCode());
                orderEffectiveInfoBo.setBusinessTypeCode(effectivePO.getBusinessTypeCode());
                orderEffectiveInfoBo.setSupplierNo(effectivePO.getSupplierNo());
                orderEffectiveInfoBo.setSupplierName(effectivePO.getSupplierName());
                orderEffectiveInfoBo.setAging(effectivePO.getAging());
                orderEffectiveInfoBo.setSourceCode(effectivePO.getSourceCode());
                orderEffectiveInfoBo.setOperatingTime(effectivePO.getOperatingTime());
                orderEffectiveInfoBo.setOperatorId(effectivePO.getOperatorId());
                orderEffectiveInfoBo.setOperatorName(effectivePO.getOperatorName());
                if (null != effectiveNameMap) {
                    orderEffectiveInfoBo.setEffectiveName(effectiveNameMap.get(effectivePO.getEffectiveCode()));
                }
                if (null != businessTypeMap) {
                    orderEffectiveInfoBo.setBusinessTypeName(businessTypeMap.get(effectivePO.getBusinessTypeCode()));
                }
                if (null != sourceNameMap) {
                    orderEffectiveInfoBo.setSourceName(sourceNameMap.get(effectivePO.getSourceCode()));
                }
                rows.add(orderEffectiveInfoBo);
            }
            rspBo.setRows(rows);
        }
        return rspBo;
    }

    private List<UocSysDictionaryDo> getEffectiveCodeListByEffectiveName() {
        return this.iUocSysDictionaryModel.qryDicListByPCodes(Collections.singletonList("EFFECTIVE_CODE"));
    }

    private Map<String, Map<String, String>> getDicValName(Map<String, String> effectiveNameMap) {
        ArrayList<String> pCodes = new ArrayList<String>();
        if (null == effectiveNameMap) {
            pCodes.add("EFFECTIVE_CODE");
        }
        pCodes.add("UOC_SALE_ORDER_SOURCE");
        pCodes.add("SOURCE_CODE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

