package com.tydic.dyc.oc.model.common;

import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.order.sub.UocTodo;

import java.util.List;

/**
 * 标题:IUocCommonModel
 * 说明:公共model
 * 时间:2022/4/1 10:21
 * 作者:罗有
 */

public interface IUocCommonModel {
    /*
     * @Author lsl
     * @Description //TODO 根据供应商编码查询对应的供应商配置信息
     * @Date 18:02 2022/4/7
     * @Param [goodsSupplierNo]
     * @return
     */
    UocConfSupplierBo qryConfSupplier(String goodsSupplierNo);

    List<UocConfSupplierDO> qryConfSupplierList(UocConfSupplierDO uocConfSupplierDO);

    /**
     * 上传服务
     * @param uocCommonDo
     * @return
     */
    UocCommonDo uploadFile(UocCommonDo uocCommonDo);

    /**
     * 描述:保存外部关联数据
     * @param index 入参
     * @return int
     * @author tgy
     * @date 2022/4/13 10:35
     */
    int saveOrderQueryIndex(UocOrderQueryIndex index);

    UocCommonDo dealTask(UocCommonDo uocCommonDo);

    List<UocOrderTaskInst> qryTaskInst(UocOrderTaskInst uocOrderTaskInst);

    /**
     * 保存待办信息
     * @param uocTodo
     * @return
     */
    int saveTodoInfo(UocTodo uocTodo);

    /**
     * 根据主键id更新待办信息
     * @param uocTodo
     * @return
     */
    int updateTodoById(UocTodo uocTodo);

    /**
     * 查询单条待办信息
     * @param uocTodo
     * @return
     */
    UocTodo getTodoInfo(UocTodo uocTodo);

    /**
     * 查询多条待办信息
     * @param uocTodo
     * @return
     */
    List<UocTodo> getTodoListInfo(UocTodo uocTodo);

    /**
     * 批量插入待办信息
     * @param list
     */
    void insertBatchTodo(List<UocTodo> list);

    /**
     * 描述:根据配置编码查询配置及配置明细信息
     * @param paramCode 参数编码
     * @return com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo
     * @author tgy
     * @date 2023/1/4 11:03
     */
    UocCfcParamConfigDo qryCfcParamByCode(String paramCode);

    /**
     * 描述:更新配置项
     * @param reqDo 入参
     * @return com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo
     * @author tgy
     * @date 2023/1/4 11:02
     */
    UocCfcParamConfigItemDo updateCfcItemValue(UocCfcParamConfigItemDo reqDo);
}
