package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocPrintInspectReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPrintInspectRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * 标题:UocPrintAcceptServiceImpl
 * 说明:
 * 时间:2022/4/7 17:14
 *
 * @author 童垣杰
 */
@HTServiceImpl
public class UocPrintAcceptServiceImpl implements UocPrintInspectService {
    public static final String FILE_TYPE_OSS = "OSS";
    /**
     * fastDfs
     */
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OBS = "OBS";

    @Value("${plugin.file.type}")
    private String fileType;
    @Value("${oss.accessUrl:}")
    private String ossFileUrl;
    @Value("${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value("${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value("${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @Value("${obs.fileUrl:}")
    private String obsFileUrl;

    // 代理后的地址
    @Value("${oss.fileUrl:}")
    private String ossFileUrlNew;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    //打印验收单保留小数位数，默认4位
    @Value("${printInspSaveDecimalCount:4}")
    private String printInspSaveDecimalCount;


    @Override
    public UocPrintInspectRspBo printInspect(UocPrintInspectReqBo reqBo) {
        validateParam(reqBo);

        UocPrintInspectRspBo rspBo = UocRu.success(UocPrintInspectRspBo.class);
        //生成验收单pdf,并上传
        genAcceptPdf(reqBo, rspBo);
        return rspBo;
    }


    /**
     * 入参检验
     *
     * @param reqBo 入参
     */
    private void validateParam(UocPrintInspectReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocPrintAcceptReqBo]不能为空");
        }
        if (ObjectUtil.isNull(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isNull(reqBo.getInspOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[验收单ID]不能为空");
        }
        if (ObjectUtil.isNull(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单ID]不能为空");
        }
    }

    private void genAcceptPdf(UocPrintInspectReqBo reqBo, UocPrintInspectRspBo rspBo) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        //创建pdf文档
        Document document = new Document(PageSize.A4.rotate(), -75, -75, 15, 40);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance(document, byteArrayOutputStream);
        } catch (DocumentException e) {
            e.printStackTrace();
        }

        //定义字体
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.EMBEDDED);
        } catch (Exception e) {
            rspBo.setRespDesc("定义字体出错：" + e);
            rspBo.setRespCode(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR);
            return;
        }
        //标题字体设置
        Font titleFont = new Font(baseFont, 14, Font.BOLD);
        //表格字体设置
        Font contentFont = new Font(baseFont, 8, Font.NORMAL);
        //页码字体设置
        Font footerFont = new Font(baseFont, 10, Font.BOLD);

        //定义列数
        final int COLUMNS = 10;
        //打开pdf文档
        document.open();


        //标题部分
        PdfPTable titleTable = new PdfPTable(1);
        PdfPCell titleCell = new PdfPCell(new Phrase("到货验收单", titleFont));
        titleCell.setColspan(1);
        titleCell.setBorder(0);
        titleCell.setFixedHeight(30);
        titleCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        titleCell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        titleTable.addCell(titleCell);
        try {
            document.add(titleTable);
        } catch (DocumentException e) {
            rspBo.setRespDesc("pdf追加table出错：" + e);
            rspBo.setRespCode(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR);
            return;
        }

        //查询验收单主体信息
        UocInspOrderDo inspOrderMain = iUocInspOrderModel.getInspOrderMain(UocRu.js(reqBo, UocInspOrderQryBo.class));
        if (inspOrderMain == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR, "未查询到对应应验收单");
        }

        //查询销售单主体信息
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(UocRu.js(reqBo, UocSaleOrderQryBo.class));
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR, "未查询到对应销售单");
        }

        //查询销售单详情信息
        List<UocSaleOrderItem> saleOrderItems = iUocSaleOrderModel.qryListSaleOrderItem(UocRu.js(reqBo, UocSaleOrderItemQryBo.class)).getSaleOrderItems();
        if (CollectionUtils.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR, "未查询到对应销售单详情");
        }

        //查询验收单详情信息
        List<UocInspOrderItem> uocInspOrderItemList = iUocInspOrderModel.getListInspOrderItem(UocRu.js(reqBo, UocInspOrderItemQryBo.class)).getUocInspOrderItemList();
        if (CollectionUtils.isEmpty(uocInspOrderItemList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR, "未查询到对应验收单详情");
        }

        //查询发货单详情信息
        List<UocShipOrderItem> shipOrderItemBoList = iUocShipOrderModel.getListShipOrderItem(UocRu.js(reqBo, UocShipOrderItemQryBo.class)).getShipOrderItemBoList();
        if (CollectionUtils.isEmpty(shipOrderItemBoList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR, "未查询到对应发货单详情");
        }


        //获取验收单map,以SaleOrderItemId为key
        Map<Long, UocInspOrderItem> inspOrdermap = uocInspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getSaleOrderItemId, e -> e));
        //过滤，获取对应验收单的销售单数组
        List<UocSaleOrderItem> uocSaleOrderItemList = saleOrderItems.stream().filter(e -> inspOrdermap.get(e.getSaleOrderItemId()) != null).collect(Collectors.toList());
        //过滤，获取对应验收单的发货单map数组
        Map<Long, UocShipOrderItem> shipItemMap = shipOrderItemBoList.stream().filter(e -> inspOrdermap.get(e.getSaleOrderItemId()) != null).collect(Collectors.toMap(UocShipOrderItem::getSaleOrderItemId, e -> e));

        //查询发货单主体信息
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderId(shipItemMap.get(uocSaleOrderItemList.get(0).getSaleOrderItemId()).getShipOrderId());
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        if (uocShipOrderDo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR, "未查询到对应发货单");
        }


        //23-04-10 修改打印bug：http://39.107.159.45/pro/bug-view-111070.html----
        //查询外部发货单编号
        //组装发货单编号
        //iUocOrderModel
        //iUocShipOrderModel

        //查询该订单下所有发货单
        UocShipOrderQryBo qryOrderShipBo = new UocShipOrderQryBo();
        qryOrderShipBo.setOrderId(reqBo.getOrderId());
        List<UocShipOrderDo> listShipOrderList = iUocShipOrderModel.getListShipOrder(qryOrderShipBo);
        Map<Long, UocShipOrderDo> shipMap = listShipOrderList.stream().collect(Collectors.toMap(UocShipOrderDo::getShipOrderId, item -> item));

        //查询该订单下所有发货单外部单编号
        UocOrderQueryIndexQryBo qryOutOrderBo = new UocOrderQueryIndexQryBo();
        qryOutOrderBo.setOrderId(reqBo.getOrderId());
        qryOutOrderBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        List<UocOrderQueryIndex> uocOrderQueryIndicesList = iUocOrderModel.qryOrderQueryIndexList(qryOutOrderBo);
        Map<Long, String> shipOutNoMap = uocOrderQueryIndicesList.stream().collect(Collectors.toMap(UocOrderQueryIndex::getObjId, UocOrderQueryIndex::getOutObjId));

        //内部发货单编号，外部发货单编号，逗号隔开
        StringBuilder innerShipOrderNo = new StringBuilder();
        StringBuilder outShipOrderNo = new StringBuilder();
        List<UocShipInspRel> uocShipInspRelList = inspOrderMain.getUocShipInspRelList();
        for (UocShipInspRel uocShipInspRel : uocShipInspRelList) {
            Long shipOrderId = uocShipInspRel.getShipOrderId();
            UocShipOrderDo shipTempBo = shipMap.get(shipOrderId);
            if (shipTempBo != null) {
                innerShipOrderNo.append(shipTempBo.getShipOrderNo()).append(",");
                String outShipNo = shipOutNoMap.get(shipOrderId);
                if (ObjectUtil.isNotEmpty(outShipNo)) {
                    outShipOrderNo.append(outShipNo).append(",");
                }
            }
        }

        String innerShipOrderNoStr = innerShipOrderNo.toString();
        String outShipOrderNoStr = outShipOrderNo.toString();
        if (outShipOrderNoStr.contains(",") && outShipOrderNoStr.endsWith(",")) {
            outShipOrderNoStr = outShipOrderNoStr.substring(0, outShipOrderNoStr.length() - 1);
        }
        if (innerShipOrderNoStr.contains(",") && innerShipOrderNoStr.endsWith(",")) {
            innerShipOrderNoStr = innerShipOrderNoStr.substring(0, innerShipOrderNoStr.length() - 1);
        }


        //第1行内容
        PdfPTable pdfPTable1 = new PdfPTable(COLUMNS);
        PdfPCell pdfPCell1 = new PdfPCell(new Phrase("发货单编号", contentFont));
        pdfPCell1.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
        pdfPCell1.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(innerShipOrderNoStr, contentFont));
        pdfPCell1.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("外部发货单编号", contentFont));
        pdfPCell1.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(outShipOrderNoStr, contentFont));
        pdfPCell1.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("下单时间", contentFont));
        pdfPCell1.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(DateFormatUtils.format(uocSaleOrderDo.getCreateTime(), "yyyy-MM-dd HH:mm:ss"), contentFont));
        pdfPCell1.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        try {
            document.add(pdfPTable1);
        } catch (DocumentException e) {
            rspBo.setRespDesc("pdf追加table出错：" + e);
            rspBo.setRespCode(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR);
            return;
        }

        //第2行内容
        PdfPTable pdfPTable2 = new PdfPTable(COLUMNS);
        PdfPCell pdfPCell2 = new PdfPCell(new Phrase("验收单位", contentFont));
        pdfPCell2.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
        pdfPCell2.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(uocSaleOrderDo.getStakeholder().getPurOrgName(), contentFont));
        pdfPCell2.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase("供应商", contentFont));
        pdfPCell2.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(uocSaleOrderDo.getStakeholder().getSupName(), contentFont));
        pdfPCell2.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        try {
            document.add(pdfPTable2);
        } catch (DocumentException e) {
            rspBo.setRespDesc("pdf追加table出错：" + e);
            rspBo.setRespCode(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR);
            return;
        }

        //表头
        PdfPTable headTable = new PdfPTable(COLUMNS);
        PdfPCell headCell = new PdfPCell(new Phrase("序号", contentFont));
        headCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        headCell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("商品名称", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("物料编码", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("物料分类", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("规格", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("型号", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("采购数量", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("计量单位", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("到货数量", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("验收数量", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("拒收数量", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("物流单号", contentFont));
        headTable.addCell(headCell);
        try {
            document.add(headTable);
        } catch (DocumentException e) {
            rspBo.setRespDesc("pdf追加table出错：" + e);
            rspBo.setRespCode(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR);
            return;
        }

        //序号
        int count = 1;

        for (UocSaleOrderItem uocSaleOrderItem : uocSaleOrderItemList) {
            PdfPTable detailTable = new PdfPTable(COLUMNS);
            PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getSkuName(), contentFont));
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getSkuMaterialId(), contentFont));
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getSkuMaterialTypeId(), contentFont));
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getSpec(), contentFont));
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);

            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getModel(), contentFont));

            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            BigDecimal purchaseCount = uocSaleOrderItem.getPurchaseCount();
            //增加小数位显示控制
            if (purchaseCount != null) {
                String result = String.format("%." + printInspSaveDecimalCount + "f", purchaseCount.doubleValue());
                detailCell.setPhrase(new Phrase(result, contentFont));
            } else {
                detailCell.setPhrase(new Phrase("", contentFont));
            }
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getUnitName(), contentFont));
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getArriveCount().toString(), contentFont));
            //增加小数位显示控制
            if (shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getArriveCount() != null) {
                String result = String.format("%." + printInspSaveDecimalCount + "f", shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getArriveCount().doubleValue());
                detailCell.setPhrase(new Phrase(result, contentFont));
            } else {
                detailCell.setPhrase(new Phrase("", contentFont));
            }
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount().toString(), contentFont));
            //增加小数位显示控制
            if (shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount() != null) {
                String result = String.format("%." + printInspSaveDecimalCount + "f", shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount().doubleValue());
                detailCell.setPhrase(new Phrase(result, contentFont));
            } else {
                detailCell.setPhrase(new Phrase("", contentFont));
            }
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getRefuseCount().toString(), contentFont));
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocShipOrderDo.getShipCompanyNo(), contentFont));
            detailCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            try {
                document.add(detailTable);
            } catch (DocumentException e) {
                rspBo.setRespDesc("pdf追加table出错：" + e);
                rspBo.setRespCode(UocRspConstants.RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR);
                return;
            }
        }


        //关闭pdf文档
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        InputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        UocCommonDo uocCommonDo = new UocCommonDo();

        UocFile uocFile = new UocFile();
        uocFile.setPath(PATH);
        uocFile.setInputStream(inputStream);
        uocFile.setFilename(fileName);
        uocFile.setFileType(fileType);
        uocCommonDo.setUocFile(uocFile);
        String path = iUocCommonModel.uploadFile(uocCommonDo).getUocFile().getUrl();

        String fileUrl;
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            fileUrl = this.ossFileUrlNew + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            fileUrl = fastdfsDownloadUrl + path;
        } else if (FILE_TYPE_OBS.equals(uocFile.getFileType())) {
            if (path.startsWith("http")) {
                fileUrl = path;
            } else {
                fileUrl = obsFileUrl + path;
            }
        } else {
            throw new ZTBusinessException("暂不支持的文件服务器类型");
        }
        rspBo.setPrintInspectUrl(fileUrl);
    }
}
