/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocPrintInspectService;
import com.tydic.dyc.oc.service.domainservice.bo.UocPrintInspectReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPrintInspectRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocPrintInspectService"})
public class UocPrintAcceptServiceImpl
implements UocPrintInspectService {
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OBS = "OBS";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${obs.fileUrl:}")
    private String obsFileUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrlNew;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Value(value="${printInspSaveDecimalCount:4}")
    private String printInspSaveDecimalCount;

    @PostMapping(value={"printInspect"})
    public UocPrintInspectRspBo printInspect(@RequestBody UocPrintInspectReqBo reqBo) {
        this.validateParam(reqBo);
        UocPrintInspectRspBo rspBo = UocRu.success(UocPrintInspectRspBo.class);
        this.genAcceptPdf(reqBo, rspBo);
        return rspBo;
    }

    private void validateParam(UocPrintInspectReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocPrintAcceptReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getInspOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9a8c\u6536\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void genAcceptPdf(UocPrintInspectReqBo reqBo, UocPrintInspectRspBo rspBo) {
        String fileUrl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e2) {
            e2.printStackTrace();
        }
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        }
        catch (Exception e3) {
            rspBo.setRespDesc("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\uff1a" + e3);
            rspBo.setRespCode("101018");
            return;
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font footerFont = new Font(baseFont, 10.0f, 1);
        int COLUMNS = 10;
        document.open();
        PdfPTable titleTable = new PdfPTable(1);
        PdfPCell titleCell = new PdfPCell(new Phrase("\u5230\u8d27\u9a8c\u6536\u5355", titleFont));
        titleCell.setColspan(1);
        titleCell.setBorder(0);
        titleCell.setFixedHeight(30.0f);
        titleCell.setHorizontalAlignment(1);
        titleCell.setVerticalAlignment(5);
        titleTable.addCell(titleCell);
        try {
            document.add((Element)titleTable);
        }
        catch (DocumentException e4) {
            rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e4));
            rspBo.setRespCode("101018");
            return;
        }
        UocInspOrderDo inspOrderMain = this.iUocInspOrderModel.getInspOrderMain(UocRu.js(reqBo, UocInspOrderQryBo.class));
        if (inspOrderMain == null) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5e94\u9a8c\u6536\u5355");
        }
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(UocRu.js(reqBo, UocSaleOrderQryBo.class));
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9500\u552e\u5355");
        }
        List<UocSaleOrderItem> saleOrderItems = this.iUocSaleOrderModel.qryListSaleOrderItem(UocRu.js(reqBo, UocSaleOrderItemQryBo.class)).getSaleOrderItems();
        if (CollectionUtils.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9500\u552e\u5355\u8be6\u60c5");
        }
        List<UocInspOrderItem> uocInspOrderItemList = this.iUocInspOrderModel.getListInspOrderItem(UocRu.js(reqBo, UocInspOrderItemQryBo.class)).getUocInspOrderItemList();
        if (CollectionUtils.isEmpty(uocInspOrderItemList)) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9a8c\u6536\u5355\u8be6\u60c5");
        }
        List<UocShipOrderItem> shipOrderItemBoList = this.iUocShipOrderModel.getListShipOrderItem(UocRu.js(reqBo, UocShipOrderItemQryBo.class)).getShipOrderItemBoList();
        if (CollectionUtils.isEmpty(shipOrderItemBoList)) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u8be6\u60c5");
        }
        Map<Long, UocInspOrderItem> inspOrdermap = uocInspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getSaleOrderItemId, e -> e));
        List uocSaleOrderItemList = saleOrderItems.stream().filter(e -> inspOrdermap.get(e.getSaleOrderItemId()) != null).collect(Collectors.toList());
        Map<Long, UocShipOrderItem> shipItemMap = shipOrderItemBoList.stream().filter(e -> inspOrdermap.get(e.getSaleOrderItemId()) != null).collect(Collectors.toMap(UocShipOrderItem::getSaleOrderItemId, e -> e));
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderId(shipItemMap.get(((UocSaleOrderItem)((Object)uocSaleOrderItemList.get(0))).getSaleOrderItemId()).getShipOrderId());
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        if (uocShipOrderDo == null) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u53d1\u8d27\u5355");
        }
        UocShipOrderQryBo qryOrderShipBo = new UocShipOrderQryBo();
        qryOrderShipBo.setOrderId(reqBo.getOrderId());
        List<UocShipOrderDo> listShipOrderList = this.iUocShipOrderModel.getListShipOrder(qryOrderShipBo);
        Map<Long, UocShipOrderDo> shipMap = listShipOrderList.stream().collect(Collectors.toMap(UocShipOrderDo::getShipOrderId, item -> item));
        UocOrderQueryIndexQryBo qryOutOrderBo = new UocOrderQueryIndexQryBo();
        qryOutOrderBo.setOrderId(reqBo.getOrderId());
        qryOutOrderBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        List<UocOrderQueryIndex> uocOrderQueryIndicesList = this.iUocOrderModel.qryOrderQueryIndexList(qryOutOrderBo);
        Map<Long, String> shipOutNoMap = uocOrderQueryIndicesList.stream().collect(Collectors.toMap(UocOrderQueryIndex::getObjId, UocOrderQueryIndex::getOutObjId));
        StringBuilder innerShipOrderNo = new StringBuilder();
        StringBuilder outShipOrderNo = new StringBuilder();
        List<UocShipInspRel> uocShipInspRelList = inspOrderMain.getUocShipInspRelList();
        for (UocShipInspRel uocShipInspRel : uocShipInspRelList) {
            Long shipOrderId = uocShipInspRel.getShipOrderId();
            UocShipOrderDo shipTempBo = shipMap.get(shipOrderId);
            if (shipTempBo == null) continue;
            innerShipOrderNo.append(shipTempBo.getShipOrderNo()).append(",");
            String outShipNo = shipOutNoMap.get(shipOrderId);
            if (!ObjectUtil.isNotEmpty((Object)outShipNo)) continue;
            outShipOrderNo.append(outShipNo).append(",");
        }
        String innerShipOrderNoStr = innerShipOrderNo.toString();
        String outShipOrderNoStr = outShipOrderNo.toString();
        if (outShipOrderNoStr.contains(",") && outShipOrderNoStr.endsWith(",")) {
            outShipOrderNoStr = outShipOrderNoStr.substring(0, outShipOrderNoStr.length() - 1);
        }
        if (innerShipOrderNoStr.contains(",") && innerShipOrderNoStr.endsWith(",")) {
            innerShipOrderNoStr = innerShipOrderNoStr.substring(0, innerShipOrderNoStr.length() - 1);
        }
        PdfPTable pdfPTable1 = new PdfPTable(10);
        PdfPCell pdfPCell1 = new PdfPCell(new Phrase("\u53d1\u8d27\u5355\u7f16\u53f7", contentFont));
        pdfPCell1.setHorizontalAlignment(2);
        pdfPCell1.setVerticalAlignment(5);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(innerShipOrderNoStr, contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u5916\u90e8\u53d1\u8d27\u5355\u7f16\u53f7", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(outShipOrderNoStr, contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u4e0b\u5355\u65f6\u95f4", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(DateFormatUtils.format((Date)uocSaleOrderDo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        try {
            document.add((Element)pdfPTable1);
        }
        catch (DocumentException e5) {
            rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e5));
            rspBo.setRespCode("101018");
            return;
        }
        PdfPTable pdfPTable2 = new PdfPTable(10);
        PdfPCell pdfPCell2 = new PdfPCell(new Phrase("\u9a8c\u6536\u5355\u4f4d", contentFont));
        pdfPCell2.setHorizontalAlignment(2);
        pdfPCell2.setVerticalAlignment(5);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(uocSaleOrderDo.getStakeholder().getPurOrgName(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase("\u4f9b\u5e94\u5546", contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(uocSaleOrderDo.getStakeholder().getSupName(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        try {
            document.add((Element)pdfPTable2);
        }
        catch (DocumentException e6) {
            rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e6));
            rspBo.setRespCode("101018");
            return;
        }
        PdfPTable headTable = new PdfPTable(10);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5546\u54c1\u540d\u79f0", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u6599\u7f16\u7801", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u6599\u5206\u7c7b", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u89c4\u683c", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u578b\u53f7", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u91c7\u8d2d\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8ba1\u91cf\u5355\u4f4d", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5230\u8d27\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u9a8c\u6536\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u62d2\u6536\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u6d41\u5355\u53f7", contentFont));
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e7) {
            rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e7));
            rspBo.setRespCode("101018");
            return;
        }
        int count = 1;
        for (UocSaleOrderItem uocSaleOrderItem : uocSaleOrderItemList) {
            String result;
            PdfPTable detailTable = new PdfPTable(10);
            PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getSkuName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getSkuMaterialName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getSkuMaterialTypeName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getSpec(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getModel(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            BigDecimal purchaseCount = uocSaleOrderItem.getPurchaseCount();
            if (purchaseCount != null) {
                result = String.format("%." + this.printInspSaveDecimalCount + "f", purchaseCount.doubleValue());
                detailCell.setPhrase(new Phrase(result, contentFont));
            } else {
                detailCell.setPhrase(new Phrase("", contentFont));
            }
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocSaleOrderItem.getUnitName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getArriveCount().toString(), contentFont));
            if (shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getArriveCount() != null) {
                result = String.format("%." + this.printInspSaveDecimalCount + "f", shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getArriveCount().doubleValue());
                detailCell.setPhrase(new Phrase(result, contentFont));
            } else {
                detailCell.setPhrase(new Phrase("", contentFont));
            }
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount().toString(), contentFont));
            if (shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount() != null) {
                result = String.format("%." + this.printInspSaveDecimalCount + "f", shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount().doubleValue());
                detailCell.setPhrase(new Phrase(result, contentFont));
            } else {
                detailCell.setPhrase(new Phrase("", contentFont));
            }
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(shipItemMap.get(uocSaleOrderItem.getSaleOrderItemId()).getRefuseCount().toString(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocShipOrderDo.getShipCompanyNo(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            try {
                document.add((Element)detailTable);
            }
            catch (DocumentException e8) {
                rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e8));
                rspBo.setRespCode("101018");
                return;
            }
        }
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        UocCommonDo uocCommonDo = new UocCommonDo();
        UocFile uocFile = new UocFile();
        uocFile.setPath(PATH);
        uocFile.setInputStream(inputStream);
        uocFile.setFilename(fileName);
        uocFile.setFileType(this.fileType);
        uocCommonDo.setUocFile(uocFile);
        String path = this.iUocCommonModel.uploadFile(uocCommonDo).getUocFile().getUrl();
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            fileUrl = this.ossFileUrlNew + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            fileUrl = this.fastdfsDownloadUrl + path;
        } else if (FILE_TYPE_OBS.equals(uocFile.getFileType())) {
            fileUrl = path.startsWith("http") ? path : this.obsFileUrl + path;
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        rspBo.setPrintInspectUrl(fileUrl);
    }
}

