package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShouldPayOrderListServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShouldPayOrderListServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayOrderBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 描述: 〈领域服务-应付单列表查询实现〉
 * @author : yuhao
 * @date : 2022/7/21 18:26
 */
@HTServiceImpl
public class UocQryShouldPayOrderListServiceImpl implements UocQryShouldPayOrderListService{

    /**
     * 应付单model
     */
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    /**
     * 应付单列表查询
     *
     * @param reqBo
     * @return
     */
    @Override
    public UocQryShouldPayOrderListServiceRspBo qryShouldPayOrderList(UocQryShouldPayOrderListServiceReqBo reqBo) {
        UocQryShouldPayOrderListServiceRspBo rspBo = new UocQryShouldPayOrderListServiceRspBo();
        UocOrderShouldPay queryUocOrderShouldPay = new UocOrderShouldPay();
        BeanUtils.copyProperties(reqBo,queryUocOrderShouldPay);
        List<UocOrderShouldPay> orderShouldPayResultList = this.iUocPayOrderModel.getListOrderShouldPay(queryUocOrderShouldPay);
        if(!CollectionUtils.isEmpty(orderShouldPayResultList)){
            List<UocShouldPayOrderBo> shouldPayOrderList = JSONArray.parseArray(JSON.toJSONString(orderShouldPayResultList)).toJavaList(UocShouldPayOrderBo.class);
            rspBo.setShouldPayOrderList(shouldPayOrderList);
        }
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }
}
