/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.UocQryLastMonthSaleOrdersCountService;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryLastMonthSaleOrdersCountServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryLastMonthSaleOrdersCountServiceRspBo;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocQryLastMonthSaleOrdersCountService"})
public class UocQryLastMonthSaleOrdersCountServiceImpl
implements UocQryLastMonthSaleOrdersCountService {
    @Autowired
    private IUocSaleOrderModel saleOrderModel;

    @PostMapping(value={"queryCounts"})
    public UocQryLastMonthSaleOrdersCountServiceRspBo queryCounts(@RequestBody UocQryLastMonthSaleOrdersCountServiceReqBo reqBo) {
        UocQryLastMonthSaleOrdersCountServiceRspBo rspBO = new UocQryLastMonthSaleOrdersCountServiceRspBo();
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        ArrayList<String> saleOrderList = new ArrayList<String>();
        saleOrderList.add(0, "XS_YS_YS");
        saleOrderList.add(1, "XS_YS_BFYS");
        uocSaleOrderDo.setSaleOrderStateList(saleOrderList);
        LocalDate firstDayOfMonth = LocalDate.now().minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDayOfMonth = LocalDate.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        String defaultEndDate = lastDayOfMonth.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        defaultEndDate = defaultEndDate + " 23:59:59";
        uocSaleOrderDo.setCreateTimeStart(Date.from(firstDayOfMonth.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        uocSaleOrderDo.setCreateTimeEnd(DateUtils.strToDate((String)defaultEndDate, (String)"yyyy-MM-dd HH:mm:ss"));
        int count = this.saleOrderModel.qrySaleCounts(uocSaleOrderDo);
        rspBO.setSaleOrderCounts(Integer.valueOf(count));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

