/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessorManager;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.domainservice.UocCreateOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqArgPayConfSupBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqPayConfBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupplierInfoBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCreateOrderService"})
public class UocCreateOrderServiceImpl
implements UocCreateOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocCreateOrderServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private UocOrderSourceProcessorManager uocOrderSourceProcessorManager;

    @PostMapping(value={"createOrder"})
    public UocCreateOrderServiceRspBo createOrder(@RequestBody UocCreateOrderServiceReqBo reqBo) {
        UocOrderDo createOrderDo = (UocOrderDo)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo), UocOrderDo.class));
        createOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createOrderDo.setCreateOperName(reqBo.getName());
        createOrderDo.setCreateTime(new Date());
        createOrderDo.setUsername(reqBo.getUserName());
        UocOrderDo orderResult = this.iUocOrderModel.createOrder(createOrderDo);
        List saleOrderItemList = JSONArray.parseArray((String)JSON.toJSONString(orderResult.getOrderItems())).toJavaList(UocSaleOrderItem.class);
        this.createSplitKey(saleOrderItemList, reqBo.getSupplierBos());
        List<UocSaleOrderDo> createSaleOrderList = this.splitSaleOrderNew(reqBo, orderResult, saleOrderItemList);
        ArrayList<UocCreateOrderServiceRspSaleOrderBo> saleOrderResultList = new ArrayList<UocCreateOrderServiceRspSaleOrderBo>();
        for (UocSaleOrderDo saleOrderDo : createSaleOrderList) {
            UocSaleOrderDo saleOrder = this.iUocSaleOrderModel.createSaleOrder(saleOrderDo);
            UocCreateOrderServiceRspSaleOrderBo orderItemRspData = new UocCreateOrderServiceRspSaleOrderBo();
            BeanUtils.copyProperties((Object)((Object)saleOrder), (Object)orderItemRspData);
            BeanUtils.copyProperties((Object)saleOrder.getStakeholder(), (Object)orderItemRspData);
            orderItemRspData.setSaleOrderId(saleOrder.getSaleOrderId());
            List<UocCreateOrderServiceRspSaleOrderItemBo> itemList = UocRu.jsl(saleOrder.getSaleOrderItems(), UocCreateOrderServiceRspSaleOrderItemBo.class);
            orderItemRspData.setItemBoList(itemList);
            orderItemRspData.setSaleOrderNo(saleOrder.getSaleOrderNo());
            orderItemRspData.setOrderSource(saleOrder.getOrderSource());
            orderItemRspData.setAgrId(saleOrder.getAgreementId());
            orderItemRspData.setModelSettle(saleOrder.getModelSettle());
            orderItemRspData.setPayType(saleOrder.getPayType() != null ? Integer.valueOf(saleOrder.getPayType()) : null);
            saleOrderResultList.add(orderItemRspData);
        }
        UocCreateOrderServiceRspBo rspBo = UocRu.success(UocCreateOrderServiceRspBo.class);
        rspBo.setTotalSaleFee(orderResult.getTotalSaleFee());
        rspBo.setTotalPurchaseFee(orderResult.getTotalPurchaseFee());
        rspBo.setOrderId(orderResult.getOrderId());
        rspBo.setOrderNo(orderResult.getOrderNo());
        rspBo.setSaleOrderList(saleOrderResultList);
        return rspBo;
    }

    private void createSplitKey(List<UocSaleOrderItem> saleOrderItemList, List<UocSupplierInfoBo> supplierBos) {
        Map<Long, UocSupplierInfoBo> supplierInfoMap = supplierBos.stream().collect(Collectors.toMap(UocSupplierInfoBo::getSupplierId, item -> item));
        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocSupplierInfoBo supplierInfoBo = supplierInfoMap.get(Long.valueOf(saleOrderItem.getSupplierId()));
            if (null == supplierInfoBo) {
                throw new BaseBusinessException("100100", "\u4f9b\u5e94\u5546\u652f\u4ed8\u914d\u7f6e\u96c6\u5408\u6ca1\u6709\u5305\u542b\u5b8c\u6240\u6709\u7684\u5546\u54c1\uff01");
            }
            String supplierIdModelSettelKey = "";
            supplierIdModelSettelKey = ObjectUtil.isNotEmpty((Object)supplierInfoBo.getExtPayConfigBos()) && supplierInfoBo.getExtSkuCategoryIds().contains(saleOrderItem.getCommodityTypeId()) ? saleOrderItem.getSupplierId() + "_" + ((UocCreateOrderServiceReqPayConfBo)supplierInfoBo.getExtPayConfigBos().get(0)).getModelSettle() : saleOrderItem.getSupplierId() + "_" + ((UocCreateOrderServiceReqPayConfBo)supplierInfoBo.getPayConfigBos().get(0)).getModelSettle();
            saleOrderItem.setSupplierIdModelSettelKey(supplierIdModelSettelKey);
        }
    }

    private List<UocSaleOrderDo> splitSaleOrderNew(UocCreateOrderServiceReqBo reqBo, UocOrderDo orderInfo, List<UocSaleOrderItem> saleOrderItemList) {
        ArrayList<UocSaleOrderDo> saleOrderList = new ArrayList<UocSaleOrderDo>();
        ArrayList<List<UocSaleOrderItem>> splitSaleOrderResultList = new ArrayList<List<UocSaleOrderItem>>();
        Map<Integer, List<UocSaleOrderItem>> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSkuSource));
        for (Map.Entry<Integer, List<UocSaleOrderItem>> entry : saleOrderItemMap.entrySet()) {
            UocOrderSourceProcessor instance = this.uocOrderSourceProcessorManager.getInstance(entry.getKey());
            splitSaleOrderResultList.addAll(instance.splitSaleOrder(entry.getValue()));
        }
        List supplierInfoList = reqBo.getSupplierBos();
        Map<Object, Object> supplierInfoMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)supplierInfoList)) {
            supplierInfoMap = supplierInfoList.stream().collect(Collectors.toMap(UocSupplierInfoBo::getSupplierId, item -> item));
        }
        List agrPayConfigList = reqBo.getAgrPayConfigList();
        Map<Object, Object> agrPayConfigMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)agrPayConfigList)) {
            agrPayConfigMap = agrPayConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqArgPayConfSupBo::getAgrId, item -> item));
        }
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(orderInfo.getOrderId());
        List<UocOrderStakeholderQryBo> orderStakeholderList = this.iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        Map<String, List<UocOrderStakeholderQryBo>> orderStakeholderMap = orderStakeholderList.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));
        for (List list : splitSaleOrderResultList) {
            UocSaleOrderDo createSaleOrderDo = new UocSaleOrderDo();
            BeanUtils.copyProperties((Object)((Object)orderInfo), (Object)((Object)createSaleOrderDo));
            createSaleOrderDo.setSaleOrderItems(list);
            createSaleOrderDo.setSaleOrderAccessoryList(orderInfo.getAccessoryList());
            createSaleOrderDo.setOrderSource(((UocSaleOrderItem)((Object)list.get(0))).getSkuSource());
            createSaleOrderDo.setStakeholderId(orderStakeholderMap.get(((UocSaleOrderItem)((Object)list.get(0))).getSupplierId()).get(0).getStakeholderId());
            createSaleOrderDo.setStakeholder(UocRu.js(orderStakeholderMap.get(((UocSaleOrderItem)((Object)list.get(0))).getSupplierId()).get(0), UocSaleStakeholder.class));
            createSaleOrderDo.setTotalSaleFee(this.computeSaleOrderTotalSaleFee(list));
            createSaleOrderDo.setTotalPurchaseFee(this.computeSaleOrderTotalPurchaseFee(list));
            createSaleOrderDo.setCreatedResult(UocConstant.CREATED_RESULT.SUCCESS);
            if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(((UocSaleOrderItem)((Object)list.get(0))).getSkuSource())) {
                createSaleOrderDo.setCreatedResult(UocConstant.CREATED_RESULT.PROCESSING);
            }
            if ("1".equals(((UocSupplierInfoBo)supplierInfoMap.get(Long.valueOf(((UocSaleOrderItem)((Object)list.get(0))).getSupplierId()))).getMonthReceiveNode())) {
                createSaleOrderDo.setIsCreateServiceFee(true);
            }
            if (StringUtils.isNotEmpty((CharSequence)((UocSaleOrderItem)((Object)list.get(0))).getAgreementId())) {
                List payConfigBos = JSONArray.parseArray((String)JSON.toJSONString((Object)((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)((Object)list.get(0))).getAgreementId())).getConfBos())).toJavaList(UocSaleOrderPayConf.class);
                List agrList = orderInfo.getOrderItems().stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getAgreementId())).map(UocOrderItem::getAgrBo).collect(Collectors.toList());
                Map agrMap = agrList.stream().collect(Collectors.toMap(UocOrderAgreement::getAgreementId, Function.identity(), (oldValue, newValue) -> newValue));
                for (UocSaleOrderPayConf payConf : payConfigBos) {
                    BigDecimal totalFee = UocDicConstant.USE_TYPE.PUR.equals(payConf.getUserType()) ? createSaleOrderDo.getTotalSaleFee() : createSaleOrderDo.getTotalPurchaseFee();
                    if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
                        payConf.setPrePayFee(totalFee);
                        continue;
                    }
                    if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
                        if (ObjectUtil.isNotEmpty((Object)payConf.getPrePaySup())) {
                            payConf.setPrePayFee(totalFee.multiply(payConf.getPrePaySup()).multiply(new BigDecimal("0.01")));
                        }
                        if (ObjectUtil.isNotEmpty((Object)payConf.getVerPaySup())) {
                            payConf.setVerPayFee(totalFee.multiply(payConf.getVerPaySup()));
                        }
                        if (ObjectUtil.isNotEmpty((Object)payConf.getPilPaySup())) {
                            payConf.setPilPayFee(totalFee.multiply(payConf.getPilPaySup()));
                        }
                        if (!ObjectUtil.isNotEmpty((Object)payConf.getQuaPaySup())) continue;
                        payConf.setQuaPayFee(totalFee.multiply(payConf.getQuaPaySup()));
                        continue;
                    }
                    if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
                        if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                            payConf.setVerPayFee(totalFee);
                            continue;
                        }
                        if (!UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayAccountDayRule())) continue;
                        payConf.setPilPayFee(totalFee);
                        continue;
                    }
                    if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayNodeRule())) {
                        payConf.setVerPayFee(totalFee);
                        continue;
                    }
                    if (!UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayNodeRule())) continue;
                    payConf.setPilPayFee(totalFee);
                }
                createSaleOrderDo.setSaleOrderPayConfList(payConfigBos);
                createSaleOrderDo.setModelSettle(((UocCreateOrderServiceReqPayConfBo)((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)((Object)list.get(0))).getAgreementId())).getConfBos().get(0)).getModelSettle());
                createSaleOrderDo.setAdjustPrice(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)((Object)list.get(0))).getAgreementId())).getAdjustPrice());
                createSaleOrderDo.setAgreementId(((UocSaleOrderItem)((Object)list.get(0))).getAgreementId());
                createSaleOrderDo.setAgreementNo(((UocSaleOrderItem)((Object)list.get(0))).getAgreementNo());
                createSaleOrderDo.setAgrDataId(((UocOrderAgreement)agrMap.get(((UocSaleOrderItem)((Object)list.get(0))).getAgreementId())).getId());
                createSaleOrderDo.setProDeliveryId(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)((Object)list.get(0))).getAgreementId())).getProDeliveryId());
                createSaleOrderDo.setProDeliveryName(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)((Object)list.get(0))).getAgreementId())).getProDeliveryName());
            } else {
                List payConfigBos;
                UocSupplierInfoBo supplierInfoBo = (UocSupplierInfoBo)supplierInfoMap.get(Long.valueOf(((UocSaleOrderItem)((Object)list.get(0))).getSupplierId()));
                if (ObjectUtil.isNotEmpty((Object)supplierInfoBo.getExtSkuCategoryIds()) && supplierInfoBo.getExtSkuCategoryIds().contains(((UocSaleOrderItem)((Object)list.get(0))).getCommodityTypeId())) {
                    payConfigBos = JSONArray.parseArray((String)JSON.toJSONString((Object)supplierInfoBo.getExtPayConfigBos())).toJavaList(UocSaleOrderPayConf.class);
                    createSaleOrderDo.setModelSettle(((UocCreateOrderServiceReqPayConfBo)supplierInfoBo.getExtPayConfigBos().get(0)).getModelSettle());
                } else {
                    payConfigBos = JSONArray.parseArray((String)JSON.toJSONString((Object)supplierInfoBo.getPayConfigBos())).toJavaList(UocSaleOrderPayConf.class);
                    createSaleOrderDo.setModelSettle(((UocCreateOrderServiceReqPayConfBo)supplierInfoBo.getPayConfigBos().get(0)).getModelSettle());
                }
                for (UocSaleOrderPayConf payConf : payConfigBos) {
                    BigDecimal totalFee = UocDicConstant.USE_TYPE.PUR.equals(payConf.getUserType()) ? createSaleOrderDo.getTotalSaleFee() : createSaleOrderDo.getTotalPurchaseFee();
                    if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
                        payConf.setPrePayFee(totalFee);
                        continue;
                    }
                    if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
                        if (ObjectUtil.isNotEmpty((Object)payConf.getPrePaySup())) {
                            payConf.setPrePayFee(totalFee.multiply(payConf.getPrePaySup()).multiply(new BigDecimal("0.01")));
                        }
                        if (ObjectUtil.isNotEmpty((Object)payConf.getVerPaySup())) {
                            payConf.setVerPayFee(totalFee.multiply(payConf.getVerPaySup()));
                        }
                        if (ObjectUtil.isNotEmpty((Object)payConf.getPilPaySup())) {
                            payConf.setPilPayFee(totalFee.multiply(payConf.getPilPaySup()));
                        }
                        if (!ObjectUtil.isNotEmpty((Object)payConf.getQuaPaySup())) continue;
                        payConf.setQuaPayFee(totalFee.multiply(payConf.getQuaPaySup()));
                        continue;
                    }
                    if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
                        if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                            payConf.setVerPayFee(totalFee);
                            continue;
                        }
                        if (!UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayAccountDayRule())) continue;
                        payConf.setPilPayFee(totalFee);
                        continue;
                    }
                    if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayNodeRule())) {
                        payConf.setVerPayFee(totalFee);
                        continue;
                    }
                    if (!UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayNodeRule())) continue;
                    payConf.setPilPayFee(totalFee);
                }
                createSaleOrderDo.setSaleOrderPayConfList(payConfigBos);
            }
            createSaleOrderDo = this.deliveryCycle(createSaleOrderDo);
            saleOrderList.add(createSaleOrderDo);
        }
        return saleOrderList;
    }

    private BigDecimal computeSaleOrderTotalPurchaseFee(List<UocSaleOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getPurchasePrice()));
        }
        return saleFee;
    }

    private BigDecimal computeSaleOrderTotalSaleFee(List<UocSaleOrderItem> orderItem) {
        BigDecimal totalSaleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            totalSaleFee = totalSaleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getSalePrice()));
        }
        return totalSaleFee;
    }

    private UocSaleOrderDo deliveryCycle(UocSaleOrderDo createSaleOrderDo) {
        if (createSaleOrderDo.getOrderSource().equals(UocConstant.SkuSource.AGR)) {
            List<UocSaleOrderItem> uocSaleOrderItems = createSaleOrderDo.getSaleOrderItems();
            uocSaleOrderItems.forEach(obj -> {
                if (StringUtils.isNotEmpty((CharSequence)obj.getDeliveryTimeDate())) {
                    ArrayList<UocSaleItemMap> saleItemMapList = new ArrayList<UocSaleItemMap>();
                    UocSaleItemMap uocSaleItemMap = new UocSaleItemMap();
                    uocSaleItemMap.setFieldCode("delivery_cycle");
                    uocSaleItemMap.setFieldName("\u4f9b\u8d27\u5468\u671f");
                    uocSaleItemMap.setFieldValue(obj.getDeliveryTimeDate());
                    saleItemMapList.add(uocSaleItemMap);
                    obj.setSaleItemMapList(saleItemMapList);
                }
            });
            createSaleOrderDo.setSaleOrderItems(uocSaleOrderItems);
        }
        return createSaleOrderDo;
    }
}

