package com.tydic.dyc.oc.service.checkorder;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.oc.model.checkorder.UocOutCheckOrderDo;
import com.tydic.dyc.oc.model.checkorder.UocOutCheckOrderModel;
import com.tydic.dyc.oc.service.checkorder.bo.UocGetOutCheckOrderInfoServiceReqBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocGetOutCheckOrderInfoServiceRspBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocOutCheckOrderBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@HTServiceImpl
public class UocGetOutCheckOrderInfoServiceImpl implements UocGetOutCheckOrderInfoService {
    
    @Autowired
    private UocOutCheckOrderModel uocOutCheckOrderModel;
    
    @Override
    public UocGetOutCheckOrderInfoServiceRspBo getCheckOrderInfo(UocGetOutCheckOrderInfoServiceReqBo reqBo) {
        UocGetOutCheckOrderInfoServiceRspBo rspBo = UocRu.success(UocGetOutCheckOrderInfoServiceRspBo.class);
        
        UocOutCheckOrderDo uocOutCheckOrderDo = new UocOutCheckOrderDo();
        uocOutCheckOrderDo.setCheckType(reqBo.getCheckType());
        uocOutCheckOrderDo.setSupplier(reqBo.getSupplier());
        uocOutCheckOrderDo.setOrderTimeStart(DateUtils.strToDate(reqBo.getOrderTimeStart(),"yyyy-MM-dd HH:mm:ss"));
        uocOutCheckOrderDo.setOrderTimeEnd(DateUtils.strToDate(reqBo.getOrderTimeEnd(),"yyyy-MM-dd HH:mm:ss"));
        List<UocOutCheckOrderDo> uocOutCheckOrderDoList = uocOutCheckOrderModel.selectOutCheckOrderList(uocOutCheckOrderDo);
        List<UocOutCheckOrderBo> uocOutCheckOrderBoList = UocRu.jsl(uocOutCheckOrderDoList, UocOutCheckOrderBo.class);
        
        rspBo.setOrderBos(uocOutCheckOrderBoList);
        return rspBo;
    }
}
