package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * @Author lsl
 * @Description //TODO 电商订单消息处理，用于处理妥投、拒收状态修改接口实现
 * @Date 16:30 2022/4/12
 * @Param
 * @return
 */
@HTServiceImpl
@Slf4j
public class UocMsgCreateOrderCompleteServiceImpl implements UocMsgCreateOrderCompleteService {
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Override
    public UocMsgCreateOrderCompleteServiceRspBo completeOrder(UocMsgCreateOrderCompleteServiceReqBo reqBo) {
        log.info("处理订单完成消息入参：{}",reqBo.toString());
        UocMsgCreateOrderCompleteServiceRspBo rspBo = new UocMsgCreateOrderCompleteServiceRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
    
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        
        if(ObjectUtil.isEmpty(uocSaleOrderDo)){
            rspBo.setRespCode(UocRspConstants.RSP_CODE_FAIL);
            rspBo.setRespDesc("查询销售单表为空");
            return  rspBo;
        }
        
        // 1、 将销售单状态全部更新为 已到货；
        uocSaleOrderDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_DH_DH);
        
        iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        
        //1.2、更新销售单明细上得到货数量=发货数量
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        List<UocSaleOrderItem> uocSaleOrderItems =  iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        //到货数量=发货数量
        for (UocSaleOrderItem uocSaleOrderItem : uocSaleOrderItems){
            uocSaleOrderItem.setArriveCount(uocSaleOrderItem.getSendCount());
            uocSaleOrderItem.setRefuseCount(new BigDecimal("0"));
        }
        uocSaleOrderDo.setSaleOrderItems(uocSaleOrderItems);
        iUocSaleOrderModel.updateSaleItemArriveAccount(uocSaleOrderDo);
        
        //2、将该销售单下所有发货单状态改为 已到货，并将到货数量全部置为和发货数量一致
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        List<UocShipOrderDo>  uocShipOrderDos = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    
        if(ObjectUtil.isEmpty(uocShipOrderDos)){
            rspBo.setRespCode(UocRspConstants.RSP_CODE_FAIL);
            rspBo.setRespDesc("查询销售单下得发货单为空");
            return  rspBo;
        }
        
        for (UocShipOrderDo uocShipOrderDo: uocShipOrderDos){
            uocShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_YSH);
            iUocShipOrderModel.modifyShipOrderMain(uocShipOrderDo);
    
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
    
            uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
            List<UocShipOrderItem>  uocShipOrderItems = iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
            //到货数量=发货数量
            for (UocShipOrderItem uocShipOrderItem : uocShipOrderItems){
                uocShipOrderItem.setArriveCount(uocShipOrderItem.getSendCount());
                uocShipOrderItem.setRefuseCount(new BigDecimal("0"));
            }
            iUocShipOrderModel.modifyItemArriveCount(uocShipOrderDo);
            
        }
        
        //销售单任务提交
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocOrderTaskInst.setObjId(reqBo.getDycUocQryMsgBO().getObjId());
        uocOrderTaskInst.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInstList = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        
        if(ObjectUtil.isNotEmpty(uocOrderTaskInstList)){
            // 提交任务
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocOrderTaskInstList.get(0).getTaskInstId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111l);
            uocCommonDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        }
        return rspBo;
    }

}
