package com.tydic.dyc.oc.service.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceRspBo;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/*
 * @Author lsl
 * @Description //TODO 查询外部与内部订单关联信息接口实现
 * @Date 17:10 2022/4/8
 * @Param
 * @return
 */
@Slf4j
@HTServiceImpl
public class UocQryOutOrderIndexServiceImpl implements UocQryOutOrderIndexService {
    
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocAfOrderModel uocAfOrderModel;
    @Autowired
    private IUocSaleOrderModel uocSaleOrderModel;
    
    @Override
    public UocQryOutOrderIndexServiceRspBo qryOutOrderIndex(UocQryOutOrderIndexServiceReqBo reqBo) {
        UocQryOutOrderIndexServiceRspBo rspBo = new UocQryOutOrderIndexServiceRspBo();
        List<UocQryOutOrderIndexBo> uocQryOutOrderIndexBoList = new ArrayList<>();
        UocOrderQueryIndexQryBo uocOrderQueryIndexQryBo = new UocOrderQueryIndexQryBo();

        if(ObjectUtil.isNotEmpty(reqBo.getType()) && (5L == reqBo.getType())){
            UocDMsgPoolQryBo msgPoolQryBo = new UocDMsgPoolQryBo();
            if(!UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getSupNo()))
                    && !UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID").equals(String.valueOf(reqBo.getSupNo()))){
                msgPoolQryBo.setPackageId(reqBo.getOutOrderNo());
    
            }else{
                msgPoolQryBo.setOutOrderId(reqBo.getOutOrderNo());
//            msgPoolQryBo = iUocOrderModel.getModelByMsgId(msgPoolQryBo)
            };
            //防止电商重复发货，改查list
            List<UocDMsgPoolQryBo> msgPoolQryBoList =  iUocOrderModel.getMsgList(msgPoolQryBo);
            
            if(ObjectUtil.isNotEmpty(msgPoolQryBoList)){
                msgPoolQryBo = msgPoolQryBoList.get(0);
                uocOrderQueryIndexQryBo.setOutObjId(msgPoolQryBo.getOutOrderId());
                uocOrderQueryIndexQryBo.setOrderId(msgPoolQryBo.getOrderId());
//                uocOrderQueryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
                if (ObjectUtil.isNotEmpty(uocOrderQueryIndexList)) {
                    for (UocOrderQueryIndex item : uocOrderQueryIndexList) {
                        uocQryOutOrderIndexBoList.add(UocRu.js(item, UocQryOutOrderIndexBo.class));
                    }
                }
            }
        }else{
            uocOrderQueryIndexQryBo.setOutObjId(reqBo.getOutOrderNo());//外部订单号
            uocOrderQueryIndexQryBo.setOrderId(reqBo.getOrderId());
            uocOrderQueryIndexQryBo.setObjId(reqBo.getObjId());
            uocOrderQueryIndexQryBo.setObjType(reqBo.getObjType());
            List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            //针对取消订单查询stakeHolderId
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            if (reqBo.getOrderId()!=null&&reqBo.getObjId()!=null) {
                uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
                uocSaleOrderQryBo.setSaleOrderId(reqBo.getObjId());
                uocSaleOrderDo = uocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            }
            if (ObjectUtil.isNotEmpty(uocOrderQueryIndexList)) {
                for (UocOrderQueryIndex item : uocOrderQueryIndexList) {
                    uocQryOutOrderIndexBoList.add(UocRu.js(item, UocQryOutOrderIndexBo.class));
                }
                UocSaleOrderDo finalUocSaleOrderDo = uocSaleOrderDo;
                Optional.ofNullable(reqBo.getOrderId()).ifPresent(x->{
                    UocOrderStakeholderQryBo qryBo = new UocOrderStakeholderQryBo();
                    qryBo.setOrderId(uocOrderQueryIndexList.get(0).getOrderId());
                    if(finalUocSaleOrderDo.getStakeholderId()!=null) qryBo.setStakeholderId(finalUocSaleOrderDo.getStakeholderId());
                    qryBo.setSupId(reqBo.getSupNo());
                    List<UocOrderStakeholderQryBo> qryBoList = iUocOrderModel.qryStakeholderList(qryBo);
                    if(ObjectUtil.isNotEmpty(qryBoList)){
                        rspBo.setSupplierNo(qryBoList.get(0).getSupId());
                    }
                });
            }
        }

        rspBo.setQryOutOrderIndexBoList(uocQryOutOrderIndexBoList);
        return rspBo;
    }
}
