package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingSkuListBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingSkuListReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingSkuListRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author DUM
 * @date 2023/8/8
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocQryBargainingSkuListServiceImpl implements UocQryBargainingSkuListService{
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Override
    public UocQryBargainingSkuListRspBo qryBargainingSkuList(UocQryBargainingSkuListReqBo uocQryBargainingSkuListReqBo) {
        UocQryBargainingSkuListRspBo rspBo = UocRu.success(UocQryBargainingSkuListRspBo.class);
        rspBo.setPageNo(uocQryBargainingSkuListReqBo.getPageNo());
        //组织查询条件
        UocBargainingItemQryBo uocBargainingItemQryBo = new UocBargainingItemQryBo();
        uocBargainingItemQryBo.setBargainingNo(uocQryBargainingSkuListReqBo.getBargainingNo());
        uocBargainingItemQryBo.setSkuCode(uocQryBargainingSkuListReqBo.getSkuCode());
        uocBargainingItemQryBo.setSkuName(uocQryBargainingSkuListReqBo.getSkuName());
        uocBargainingItemQryBo.setSupId(uocQryBargainingSkuListReqBo.getSupplierId());
        uocBargainingItemQryBo.setBargainingOperName(uocQryBargainingSkuListReqBo.getBargainingOperName());
        uocBargainingItemQryBo.setCreateTimeStart(uocQryBargainingSkuListReqBo.getCreateTimeStart());
        uocBargainingItemQryBo.setCreateTimeEnd(uocQryBargainingSkuListReqBo.getCreateTimeEnd());
        uocBargainingItemQryBo.setPurOrgId(uocQryBargainingSkuListReqBo.getPurchaseId());
        uocBargainingItemQryBo.setPageNo(uocQryBargainingSkuListReqBo.getPageNo());
        uocBargainingItemQryBo.setPageSize(uocQryBargainingSkuListReqBo.getPageSize());
        BasePageRspBo<UocBargainingItem> itemBasePageRspBo = uocBargainingModel.getListPageBargainingItem(uocBargainingItemQryBo);
        if (CollectionUtils.isEmpty(itemBasePageRspBo.getRows())) {
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList<>(0));
        } else {
            //获取字典集合(翻译状态)
            List<String> pCodes = new ArrayList<>();
            pCodes.add(UocDicConstant.BARGAINING_STATE.P_CODE);
            Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodes);
            itemBasePageRspBo.getRows().forEach(uocBargainingItem -> {
                uocBargainingItem.setBargainingStateStr(dictionaryMap.get(UocDicConstant.BARGAINING_STATE.P_CODE).get(uocBargainingItem.getBargainingState()));
                if (ObjectUtil.isNotEmpty(uocBargainingItem.getConfirmedPriceSub())) {
                    //商品明细单价折扣率
                    BigDecimal skuDiscountRate = new BigDecimal(0);
                    skuDiscountRate = uocBargainingItem.getConfirmedPriceSub().divide(uocBargainingItem.getPurchaseFee(), 2, BigDecimal.ROUND_HALF_UP);
                    uocBargainingItem.setDiscountRate(skuDiscountRate);
                }
            });
            rspBo.setTotal(itemBasePageRspBo.getTotal());
            rspBo.setRecordsTotal(itemBasePageRspBo.getRecordsTotal());
            List<UocQryBargainingSkuListBo> rows =  UocRu.jsl(itemBasePageRspBo.getRows(), UocQryBargainingSkuListBo.class);
            rspBo.setRows(rows);
        }
        return rspBo;
    }
}
