package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.qrybo.UocQryMateriaOrderNoBo;
import com.tydic.dyc.oc.service.common.UocQryMateriaIdBySkuService;
import com.tydic.dyc.oc.service.common.bo.UocQryMateriaIdBySkuServiceReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQryMateriaIdBySkuServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocQryMateriaIdBySkuServiceImpl
 * 说明:
 * 时间:2023/1/6 18:59
 * 作者:田桂银
 */
@HTServiceImpl
public class UocQryMateriaIdBySkuServiceImpl implements UocQryMateriaIdBySkuService {

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocQryMateriaIdBySkuServiceRspBo qryMateria(UocQryMateriaIdBySkuServiceReqBo reqBo) {
        UocQryMateriaIdBySkuServiceRspBo rspBo = UocRu.success(UocQryMateriaIdBySkuServiceRspBo.class);
        validateArg(reqBo);
        UocQryMateriaOrderNoBo qryMateria = new UocQryMateriaOrderNoBo();
        qryMateria.setSkuId(reqBo.getSkuId());
        qryMateria.setPurUserId(reqBo.getUserIdIn().toString());
        UocQryMateriaOrderNoBo uocQryMateriaOrderNoBo = iUocCommonModel.qryMateriaBySkuIdAndUserId(qryMateria);
        if(ObjectUtil.isNotEmpty(uocQryMateriaOrderNoBo)){
            rspBo.setSkuMaterialId(uocQryMateriaOrderNoBo.getSkuMaterialId());
            rspBo.setSkuMaterialCode(uocQryMateriaOrderNoBo.getSkuMaterialCode());
        }
        return rspBo;
    }

    private void validateArg(UocQryMateriaIdBySkuServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserIdIn())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[userIdIn]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSkuId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[skuId]不能为空");
        }
    }
}


