package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsServiceRspItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 描述: 〈领域服务-销售单明细列表查询 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@HTServiceImpl
public class UocGetSaleOrderItemsServiceImpl implements UocGetSaleOrderItemsService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocGetSaleOrderItemsServiceRspBo getSaleOrderItems(UocGetSaleOrderItemsServiceReqBo reqBo) {
        // 入参校验
        validateParam(reqBo);
        // 查询销售单明细
        UocGetSaleOrderItemsServiceRspBo rspBo = new UocGetSaleOrderItemsServiceRspBo();
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBo, UocSaleOrderItemQryBo.class);
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if(!CollectionUtils.isEmpty(saleOrderItemList)){
            List<UocGetSaleOrderItemsServiceRspItemBo> saleOrderItems = UocRu.jsl(saleOrderItemList,UocGetSaleOrderItemsServiceRspItemBo.class);
            rspBo.setSaleOrderItems(saleOrderItems);
        }
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }
    /**
     * 入参校验
     */
    private void validateParam(UocGetSaleOrderItemsServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }
}
