/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocPrintInspectService;
import com.tydic.dyc.oc.service.domainservice.bo.UocPrintInspectReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPrintInspectRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocPrintInspectService"})
public class UocPrintAcceptServiceImpl
implements UocPrintInspectService {
    private static final Logger log = LoggerFactory.getLogger(UocPrintAcceptServiceImpl.class);
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OBS = "OBS";
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${obs.fileUrl:}")
    private String obsFileUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrlNew;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Value(value="${printInspSaveDecimalCount:4}")
    private String printInspSaveDecimalCount;
    @Value(value="${uoc.dataAchiveFlag:false}")
    private Boolean dataAchiveFlag;

    @PostMapping(value={"printInspect"})
    public UocPrintInspectRspBo printInspect(@RequestBody UocPrintInspectReqBo reqBo) {
        this.validateParam(reqBo);
        UocPrintInspectRspBo rspBo = UocRu.success(UocPrintInspectRspBo.class);
        this.genAcceptPdf(reqBo, rspBo);
        return rspBo;
    }

    private void validateParam(UocPrintInspectReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocPrintAcceptReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getInspOrderIdList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9a8c\u6536\u5355ID\u5217\u8868]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void genAcceptPdf(UocPrintInspectReqBo reqBo, UocPrintInspectRspBo rspBo) {
        String path;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e2) {
            e2.printStackTrace();
        }
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        }
        catch (Exception e3) {
            rspBo.setRespDesc("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\uff1a" + e3);
            rspBo.setRespCode("101018");
            return;
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font footerFont = new Font(baseFont, 10.0f, 1);
        int COLUMNS = 10;
        document.open();
        PdfPTable titleTable = new PdfPTable(1);
        PdfPCell titleCell = new PdfPCell(new Phrase("\u5230\u8d27\u9a8c\u6536\u5355", titleFont));
        titleCell.setColspan(1);
        titleCell.setBorder(0);
        titleCell.setFixedHeight(30.0f);
        titleCell.setHorizontalAlignment(1);
        titleCell.setVerticalAlignment(5);
        titleTable.addCell(titleCell);
        try {
            document.add((Element)titleTable);
        }
        catch (DocumentException e4) {
            rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e4));
            rspBo.setRespCode("101018");
            return;
        }
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(UocRu.js(reqBo, UocSaleOrderQryBo.class));
        String dataAchiveTabSuffix = null;
        if (this.dataAchiveFlag.booleanValue() && Objects.isNull((Object)uocSaleOrderDo)) {
            dataAchiveTabSuffix = "_" + new SimpleDateFormat("yyyy").format((reqBo.getOrderId() >> 22) + 1420041600000L);
            UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
            uocSaleOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        }
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9500\u552e\u5355");
        }
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBo, UocSaleOrderItemQryBo.class);
        uocSaleOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocSaleOrderItem> saleOrderItems = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo).getSaleOrderItems();
        if (CollectionUtils.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9500\u552e\u5355\u8be6\u60c5");
        }
        UocInspOrderItemQryBo uocInspOrderItemQryBo = UocRu.js(reqBo, UocInspOrderItemQryBo.class);
        uocInspOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocInspOrderItem> uocInspOrderItemList = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo).getUocInspOrderItemList();
        if (CollectionUtils.isEmpty(uocInspOrderItemList)) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9a8c\u6536\u5355\u8be6\u60c5");
        }
        log.info("iUocInspOrderModel.getListInspOrderItem\u7684\u8fd4\u56de\u503c\uff1a{}", (Object)JSON.toJSONString(uocInspOrderItemList));
        UocShipOrderItemQryBo uocShipOrderItemQryBo = UocRu.js(reqBo, UocShipOrderItemQryBo.class);
        uocShipOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocShipOrderItem> shipOrderItemBoList = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo).getShipOrderItemBoList();
        if (CollectionUtils.isEmpty(shipOrderItemBoList)) {
            throw new BaseBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u8be6\u60c5");
        }
        Map<Long, UocSaleOrderItem> saleOrderItemmap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, e -> e));
        Map<Long, UocShipOrderItem> shipItemMap = shipOrderItemBoList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, e -> e));
        PdfPTable pdfPTable1 = new PdfPTable(10);
        PdfPCell pdfPCell1 = new PdfPCell(new Phrase("\u8ba2\u5355\u7f16\u53f7", contentFont));
        pdfPCell1.setHorizontalAlignment(2);
        pdfPCell1.setVerticalAlignment(5);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(uocSaleOrderDo.getSaleOrderNo(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u7b2c\u4e09\u65b9\u8ba2\u5355\u7f16\u53f7", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(uocSaleOrderDo.getSaleOrderNoExt(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u4e0b\u5355\u65f6\u95f4", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(DateFormatUtils.format((Date)uocSaleOrderDo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        try {
            document.add((Element)pdfPTable1);
        }
        catch (DocumentException e5) {
            rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e5));
            rspBo.setRespCode("101018");
            return;
        }
        PdfPTable pdfPTable2 = new PdfPTable(10);
        PdfPCell pdfPCell2 = new PdfPCell(new Phrase("\u9a8c\u6536\u5355\u4f4d", contentFont));
        pdfPCell2.setHorizontalAlignment(2);
        pdfPCell2.setVerticalAlignment(5);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(uocSaleOrderDo.getStakeholder().getPurCompanyName(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase("\u4f9b\u5e94\u5546", contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(uocSaleOrderDo.getStakeholder().getSupName(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        try {
            document.add((Element)pdfPTable2);
        }
        catch (DocumentException e6) {
            rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e6));
            rspBo.setRespCode("101018");
            return;
        }
        PdfPTable headTable = new PdfPTable(10);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5546\u54c1\u540d\u79f0", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u6599\u7f16\u7801", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u6599\u5206\u7c7b", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u89c4\u683c", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u578b\u53f7", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u91c7\u8d2d\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8ba1\u91cf\u5355\u4f4d", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5230\u8d27\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u9a8c\u6536\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e7) {
            rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e7));
            rspBo.setRespCode("101018");
            return;
        }
        int count = 1;
        for (UocInspOrderItem uocInspOrderItem : uocInspOrderItemList) {
            String result;
            PdfPTable detailTable = new PdfPTable(10);
            PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(saleOrderItemmap.get(uocInspOrderItem.getSaleOrderItemId()).getSkuName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(saleOrderItemmap.get(uocInspOrderItem.getSaleOrderItemId()).getSkuMaterialCode(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(saleOrderItemmap.get(uocInspOrderItem.getSaleOrderItemId()).getSkuMaterialTypeName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(saleOrderItemmap.get(uocInspOrderItem.getSaleOrderItemId()).getSpec(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(saleOrderItemmap.get(uocInspOrderItem.getSaleOrderItemId()).getModel(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            BigDecimal purchaseCount = saleOrderItemmap.get(uocInspOrderItem.getSaleOrderItemId()).getPurchaseCount();
            if (purchaseCount != null) {
                result = String.format("%." + this.printInspSaveDecimalCount + "f", purchaseCount.doubleValue());
                detailCell.setPhrase(new Phrase(result, contentFont));
            } else {
                detailCell.setPhrase(new Phrase("", contentFont));
            }
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(saleOrderItemmap.get(uocInspOrderItem.getSaleOrderItemId()).getUnitName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(shipItemMap.get(uocInspOrderItem.getShipOrderItemId()).getArriveCount().toString(), contentFont));
            if (shipItemMap.get(uocInspOrderItem.getShipOrderItemId()).getArriveCount() != null) {
                result = String.format("%." + this.printInspSaveDecimalCount + "f", shipItemMap.get(uocInspOrderItem.getShipOrderItemId()).getArriveCount().doubleValue());
                detailCell.setPhrase(new Phrase(result, contentFont));
            } else {
                detailCell.setPhrase(new Phrase("", contentFont));
            }
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocInspOrderItem.getInspCount().toString(), contentFont));
            if (uocInspOrderItem.getInspCount() != null) {
                result = String.format("%." + this.printInspSaveDecimalCount + "f", uocInspOrderItem.getInspCount().doubleValue());
                detailCell.setPhrase(new Phrase(result, contentFont));
            } else {
                detailCell.setPhrase(new Phrase("", contentFont));
            }
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            try {
                document.add((Element)detailTable);
            }
            catch (DocumentException e8) {
                rspBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e8));
                rspBo.setRespCode("101018");
                return;
            }
        }
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        UocCommonDo uocCommonDo = new UocCommonDo();
        UocFile uocFile = new UocFile();
        uocFile.setPath(this.instDataPath);
        uocFile.setInputStream(inputStream);
        uocFile.setFilename(fileName);
        uocFile.setFileType(this.fileType);
        uocCommonDo.setUocFile(uocFile);
        String fileUrl = path = this.iUocCommonModel.uploadFile(uocCommonDo).getUocFile().getUrl();
        rspBo.setPrintInspectUrl(fileUrl);
    }
}

