package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.common.bo.UocUnifyTodoQryReqBO;
import com.tydic.dyc.oc.service.common.bo.UocUnifyTodoQryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

@HTServiceImpl
public class UocUnifyTodoQryServiceImpl implements UocUnifyTodoQryService {

    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Override
    public UocUnifyTodoQryRspBO qryTodoInfo(UocUnifyTodoQryReqBO reqBO) {
        UocUnifyTodoQryRspBO rspBO = judge(reqBO);

        // 查询三方信息表
        qrystakeholder(reqBO.getShareId(), rspBO);
        rspBO.setOrderId(reqBO.getShareId());

        switch (reqBO.getObjType()) {
            // 订单
            case 1:
                break;
            // 销售单
            case 2:
                qrySale(reqBO.getShareId(), reqBO.getObjId(), rspBO);
                break;
            // 执行单
            case 3:
                break;
            // 发货单
            case 4:
                qryShip(reqBO.getShareId(), reqBO.getObjId(), rspBO);
                break;
            // 收货单
            case 5:
                break;
            // 售后服务单
            case 6:
                qryAfter(reqBO.getShareId(), reqBO.getObjId(), rspBO);
                break;
            // 支付单
            case 7:
                break;
            // 验收单
            case 8:
                qryInsp(reqBO.getShareId(), reqBO.getObjId(), rspBO);
                break;
            // 审批单
            case 9:
                qryAudit(reqBO.getShareId(), reqBO.getObjId(), rspBO);
                break;
            // 变更单
            case 10:
                qryChng(reqBO.getShareId(), reqBO.getObjId(), rspBO);
                break;
            default:
                break;
        }


        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 查询三方表
     */
    private void qrystakeholder(Long orderId, UocUnifyTodoQryRspBO rspBO) {
        UocOrderStakeholderQryBo qryBo = new UocOrderStakeholderQryBo();
        qryBo.setOrderId(orderId);
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = iUocOrderModel.qryStakeholderList(qryBo);
        if (CollectionUtils.isEmpty(uocOrderStakeholderQryBos)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "三方信息查询为空");
        }
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = uocOrderStakeholderQryBos.get(0);

        // 运营
        rspBO.setProOrgId(Long.parseLong(uocOrderStakeholderQryBo.getProId()));
        // 采购
        rspBO.setPurOrgId(Long.parseLong(uocOrderStakeholderQryBo.getPurOrgId()));
        rspBO.setPurOrgName(uocOrderStakeholderQryBo.getPurOrgNo());
        // 供应
        rspBO.setSupOrgId(Long.parseLong(uocOrderStakeholderQryBo.getSupId()));
    }


    /**
     * 查询销售单
     */
    private void qrySale(Long orderId, Long saleOrderId, UocUnifyTodoQryRspBO rspBO) {
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setSaleOrderId(saleOrderId);
        UocSaleOrderDo saleOrderDo = iUocSaleOrderModel.qrySaleOrder(qryBo);

        rspBO.setSaleOrderId(saleOrderDo.getSaleOrderId());
        rspBO.setSaleOrderNo(saleOrderDo.getSaleOrderNo());
        rspBO.setTotalSaleFee(saleOrderDo.getTotalSaleFee());
        rspBO.setProDeliveryName(saleOrderDo.getProDeliveryName());
        rspBO.setSaleOrderState(saleOrderDo.getSaleOrderState());
        rspBO.setModelSettle(saleOrderDo.getModelSettle());
        rspBO.setOrderSource(saleOrderDo.getOrderSource());
        rspBO.setPayType(saleOrderDo.getPayType());
        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(saleOrderDo.getCreateOperId()));
    }


    /**
     * 查询发货单
     */
    private void qryShip(Long orderId, Long shipOrderId, UocUnifyTodoQryRspBO rspBO) {
        UocShipOrderQryBo qryBo = new UocShipOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setShipOrderId(shipOrderId);
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(qryBo);

        rspBO.setShipOrderId(uocShipOrderDo.getShipOrderId());
        rspBO.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
        rspBO.setEstimateArrivalTime(uocShipOrderDo.getEstimateArrivalTime());

        // 查销售单
        qrySale(orderId, uocShipOrderDo.getSaleOrderId(), rspBO);

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(uocShipOrderDo.getCreateOperId()));
    }


    /**
     * 查询售后单
     */
    private void qryAfter(Long orderId, Long afOrderId, UocUnifyTodoQryRspBO rspBO) {
        UocAfOrderQryBo qryBo = new UocAfOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setAfOrderId(afOrderId);
        UocAfOrder uocAfOrder = iUocAfOrderModel.getAfOrderById(qryBo);

        rspBO.setAfOrderId(uocAfOrder.getAfOrderId());
        rspBO.setAfServCode(uocAfOrder.getAfServCode());

        // 查销售单
        qrySale(orderId, uocAfOrder.getSaleOrderId(), rspBO);

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(uocAfOrder.getCreateOperId()));
    }


    /**
     * 查询验收单
     */
    private void qryInsp(Long orderId, Long inspOrderId, UocUnifyTodoQryRspBO rspBO) {
        UocInspOrderQryBo qryBo = new UocInspOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setInspOrderId(inspOrderId);
        UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getInspOrderMain(qryBo);

        // TODO 待办参数，目前还没有验收单的待办

        // 查销售单
        qrySale(orderId, uocInspOrderDo.getSaleOrderId(), rspBO);

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(uocInspOrderDo.getCreateOperId()));
    }


    /**
     * 查询审批单
     */
    private void qryAudit(Long orderId, Long auditOrderId, UocUnifyTodoQryRspBO rspBO) {
        UocAuditOrderQryBo qryBo = new UocAuditOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setAuditOrderId(auditOrderId);
        UocAuditOrderDo uocAuditOrderDo = iUocAuditOrderModel.qryAuditOrder(qryBo);

        rspBO.setAuditOrderId(uocAuditOrderDo.getAuditOrderId());
        rspBO.setAuditOrderCode(uocAuditOrderDo.getAuditOrderCode());

        // 查审批人
        UocOrderTaskDealQryBo uocOrderTaskDealQryBo = new UocOrderTaskDealQryBo();
        uocOrderTaskDealQryBo.setOrderId(orderId);
        uocOrderTaskDealQryBo.setObjId(auditOrderId);
        uocOrderTaskDealQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(uocOrderTaskDealQryBo);
        if (!CollectionUtils.isEmpty(uocOrderTaskDeals)) {
            rspBO.setAuditUserIds(uocOrderTaskDeals.stream().map(e -> Long.parseLong(e.getDealId())).collect(Collectors.toList()));
        }

        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(orderId);
        uocApprovalObjQryBo.setAuditOrderId(auditOrderId);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "审批对象信息查询为空");
        }
        rspBO.setObjBusiType(uocApprovalObjs.get(0).getObjBusiType());

        // 查销售单
        if (UocDicConstant.OBJ_TYPE.SALE.equals(uocApprovalObjs.get(0).getObjType())) {
            qrySale(orderId, Long.parseLong(uocApprovalObjs.get(0).getObjId()), rspBO);
        }

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(uocAuditOrderDo.getCreateOperId()));
    }


    /**
     * 查询变更单
     */
    private void qryChng(Long orderId, Long chngOrderId, UocUnifyTodoQryRspBO rspBO) {
        UocChngOrderQryBo qryBo = new UocChngOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setChngOrderId(chngOrderId);
        UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrder(qryBo);

        rspBO.setChngOrderId(uocChngOrderDo.getChngOrderId());
        rspBO.setChngOrderNo(uocChngOrderDo.getChngOrderNo());
        rspBO.setChngBusiType(uocChngOrderDo.getBusiType());

        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setOrderId(orderId);
        uocChngOrderObjQryBo.setChngOrderId(chngOrderId);
        List<UocChngOrderObj> listChngOrderObj = iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
        if (CollectionUtils.isEmpty(listChngOrderObj)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "变更对象信息查询为空");
        }

        // 查销售单
        qrySale(orderId, listChngOrderObj.get(0).getSaleOrderId(), rspBO);

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(uocChngOrderDo.getCreateOperId()));
    }


    /**
     * 入参校验
     *
     * @return reqBO
     */
    private UocUnifyTodoQryRspBO judge(UocUnifyTodoQryReqBO reqBO) {
        if (reqBO.getShareId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参shareId不能为空");
        }
        if (reqBO.getObjId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参objId不能为空");
        }
        if (reqBO.getObjType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参objType不能为空");
        }
        if (reqBO.getTodoType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参todoType不能为空");
        }
        return new UocUnifyTodoQryRspBO();
    }

}
