package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateShouldBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 标题：UocShouldPayCalculateServiceImpl
 * 说明：应付金额计算
 * 时间：2022/4/6 19:49
 * 作者： 周中贤
 */
@SuppressWarnings("unchecked")
@Slf4j
@HTServiceImpl
public class UocShouldPayCalculateServiceImpl implements UocShouldPayCalculateService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;


    private final ThreadLocal<ConcurrentHashMap<String, Object>> threadLocal = new ThreadLocal<>();

    /**
     * 应付金额计算
     */
    @Override
    public UocShouldPayCalculateRspBO calculate(UocShouldPayCalculateReqBO reqBO) {
        val(reqBO);
        //用于存放事先查询的实体
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<>();
        UocShouldPayCalculateRspBO rspBO = new UocShouldPayCalculateRspBO();
        //待填充的应付信息
        List<UocShouldPayCalculateShouldBO> shouldPayList = new ArrayList<>();
        //根据对象类型objType计算应付金额并组装应付信息
        dealShouldPayList(reqBO, shouldPayList, concurrentHashMap,rspBO);
        //应付金额为0的过滤掉
        List<UocShouldPayCalculateShouldBO> shouldPayNoZeroList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(shouldPayList)) {
            shouldPayNoZeroList = shouldPayList.stream().filter(bo -> bo.getShouldPayAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        }

        rspBO.setShouldPayList(shouldPayNoZeroList);
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 填充应付信息
     *
     * @param reqBO             服务入参
     * @param shouldPayList     待填充的应付信息
     * @param concurrentHashMap 用于存放事先查询的实体
     */
    private void dealShouldPayList(UocShouldPayCalculateReqBO reqBO, List<UocShouldPayCalculateShouldBO> shouldPayList, ConcurrentHashMap<String, Object> concurrentHashMap,UocShouldPayCalculateRspBO rspBO) {
        //1.准备基础数据（销售单、三方表、销售单支付配置）
        //查询销售单ID
        Long saleOrderId = qrySaleOrderId(reqBO, concurrentHashMap);
        //销售单
        UocSaleOrderDo uocSaleOrderDo = qrySaleOrder(reqBO.getOrderId(), saleOrderId);
        rspBO.setSaleOrderState(uocSaleOrderDo.getSaleOrderState());
        //订单三方表
        UocSaleStakeholder stakeholder = uocSaleOrderDo.getStakeholder();
        //查询销售单支付配置
        List<UocSaleOrderPayConf> uocSaleOrderPayConfList = qrySaleOrderPayConf(reqBO.getOrderId(), saleOrderId, reqBO.getShouldPayType(), reqBO.getPayNodeRule());
        if (CollectionUtils.isEmpty(uocSaleOrderPayConfList)) {
            //未找到匹配的应付配置，直接返回
            return;
        }
        //2.填充通用属性
        fillCommonAttr(reqBO.getObjType(), reqBO.getShouldPayType(), shouldPayList, uocSaleOrderDo, stakeholder, uocSaleOrderPayConfList);
        //销售单支付配置map
        Map<Integer, UocSaleOrderPayConf> payConfMap = new HashMap<>();
        uocSaleOrderPayConfList.forEach(item -> payConfMap.put(item.getUserType(), item));
        //3.根据单据类型填充应付金额、单据id、单据编码等差异属性
        for (UocShouldPayCalculateShouldBO item : shouldPayList) {
            //从map中取出对应销售单支付配置
            UocSaleOrderPayConf payConf = payConfMap.get(item.getUserType());
            //若销售支付配置中付款方式为‘分阶段’，则根据入参‘应付类型’查询比例,否则返回100%
            BigDecimal ratio = qryRatio(reqBO, item, payConf);
            log.info("付款方式为:{}，付款比例为{}", item.getPayType(), ratio.toString());
            if (UocDicConstant.OBJ_TYPE.SALE.equals(item.getObjType())) {
                //对象类型objType为->销售单
                //根据销售单支付配置取应付金额
                if(UocDicConstant.USE_TYPE.PUR.equals(item.getUserType())){
                    //采购方取销售金额
                    item.setShouldPayAmount(uocSaleOrderDo.getTotalSaleFee().multiply(ratio));
                }else{
                    //平台方取采购金额
                    item.setShouldPayAmount(uocSaleOrderDo.getTotalPurchaseFee().multiply(ratio));
                }

                //**应付金额 取销售支付配置中的预付款(生成数据时，直接填入该值)
                /*if(payConf.getPrePayFee() == null){
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "数据异常，生成销售单支付配置时，未初始化预付款金额");
                }
                item.setShouldPayAmount(payConf.getPrePayFee());*/
                //**单据ID
                item.setObjectId(uocSaleOrderDo.getSaleOrderId());
                //**单据编码
                item.setObjectNo(uocSaleOrderDo.getSaleOrderNo());
                //**合同编号
                item.setContractNo(uocSaleOrderDo.getContractNo());
            } else if (UocDicConstant.OBJ_TYPE.SHIP.equals(item.getObjType())) {
                //对象类型objType为->发货单
                //找到发货单明细
                List<UocShipOrderItem> uocShipOrderItemList = (List<UocShipOrderItem>) concurrentHashMap.get("shipOrderItemDO");
                //找到发货单明细对应的销售单明细
                List<UocSaleOrderItem> uocSaleOrderItemList = iUocSaleOrderModel.getSaleOrderItemListByItemIds(uocShipOrderItemList.stream().map(UocShipOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
                if (CollectionUtils.isEmpty(uocSaleOrderItemList)) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "数据异常，到发货单明细对应的销售单明细为空");
                }

                /*if(UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(item.getPayType())){
                    //分阶段只推一次，取到货款
                    item.setShouldPayAmount(payConf.getVerPayFee());
                }else{*/
                    //填充金额
                    fillShipShouldPayFee(item, payConf, ratio, uocShipOrderItemList, uocSaleOrderItemList);
                /*}*/
                //取出发货单信息
                UocShipOrderDo shipOrderDO = (UocShipOrderDo) concurrentHashMap.get("shipOrderDO");
                //**单据ID
                item.setObjectId(shipOrderDO.getShipOrderId());
                //**单据编码
                item.setObjectNo(shipOrderDO.getShipOrderNo());
                //**合同编号
                item.setContractNo(uocSaleOrderDo.getContractNo());
            } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(item.getObjType())) {
                //对象类型objType为->验收单
                //找到验收单明细
                List<UocInspOrderItem> uocInspOrderItemList = (List<UocInspOrderItem>) concurrentHashMap.get("inspOrderItemDO");
                //找到明细对应的销售单明细
                List<UocSaleOrderItem> uocSaleOrderItemList = iUocSaleOrderModel.getSaleOrderItemListByItemIds(uocInspOrderItemList.stream().map(UocInspOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
                if (CollectionUtils.isEmpty(uocSaleOrderItemList)) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "数据异常，验收货单明细对应的销售单明细为空");
                }

                /*if(UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(item.getPayType())){
                    //分阶段只推一次，取验收款
                    item.setShouldPayAmount(payConf.getVerPayFee());
                }else {*/
                    //填充金额
                    fillInspShouldPayFee(item, payConf, ratio, uocInspOrderItemList, uocSaleOrderItemList);
                /*}*/
                //取出验收单信息
                UocInspOrderDo inspOrderDO = (UocInspOrderDo) concurrentHashMap.get("inspOrderDO");
                //**单据ID
                item.setObjectId(inspOrderDO.getInspOrderId());
                //**单据编码
                item.setObjectNo(inspOrderDO.getInspOrderNo());
                //**合同编号
                item.setContractNo(uocSaleOrderDo.getContractNo());
            }
        }
    }

    /**
     * 计算本条验收单应付金额
     * TODO 超验逻辑
     */
    private void fillInspShouldPayFee(UocShouldPayCalculateShouldBO item, UocSaleOrderPayConf payConf, BigDecimal ratio, List<UocInspOrderItem> uocInspOrderItemList, List<UocSaleOrderItem> uocSaleOrderItemList) {
        //！！判断是否为最后一笔验收单
        boolean lastInspOrder = true;
        /*for (UocSaleOrderItem uocSaleOrderItem : uocSaleOrderItemList) {
            if (!(uocSaleOrderItem.getAcceptanceCount().add(uocSaleOrderItem.getRefuseCount()).add(uocSaleOrderItem.getReturnCount())).equals(uocSaleOrderItem.getPurchaseCount())) {
                //存在一条销售单明细不符合（验收数量 + 拒收数量 + 退货数量 = 采购数量）的，则不是最后一笔验收单
                lastInspOrder = false;
                break;
            }
        }
        if (lastInspOrder) {
            //最后一笔
            //如果为最后一笔， 最后一笔金额 =  总验收款 - 所有生成的验收应付单价格
            //总验收款
            BigDecimal pilPayFee = payConf.getPilPayFee();
            //所有生成的验收应付单价格
            UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
            uocOrderShouldPay.setOrderId(item.getOrderId());
            uocOrderShouldPay.setObjectType(item.getObjType());

            //查询该销售单下所有验收单id
            UocInspOrderQryBo inspOrderQryBo = new UocInspOrderQryBo();
            inspOrderQryBo.setSaleOrderId(uocSaleOrderItemList.get(0).getSaleOrderId());
            List<UocInspOrderDo> inspOrderList = iUocInspOrderModel.getListInspOrder(inspOrderQryBo);
            //验收单集合
            uocOrderShouldPay.setObjectIdList(inspOrderList.stream().map(obj -> obj.getInspOrderId()).collect(Collectors.toList()));
            List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
            BigDecimal allInspShouldFee = listOrderShouldPay.stream().map(UocOrderShouldPay::getShouldPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            item.setShouldPayAmount(pilPayFee.subtract(allInspShouldFee));
        } else {
            //不是最后一笔
            //key:销售单明细ID value:对应金额
            Map<Long, BigDecimal> map = new HashMap<>();
            if (UocDicConstant.USE_TYPE.PUR.equals(item.getUserType())) {
                //采购方取 销售金额
                uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getSalePrice()));
            } else {
                //平台方取 采购金额
                uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getPurchasePrice()));
            }
            //计算金额
            BigDecimal inspPrice = new BigDecimal("0");
            for (UocInspOrderItem entity : uocInspOrderItemList) {
                //发货数量*金额
                BigDecimal price = map.get(entity.getSaleOrderItemId());
                if (price == null) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "map数据缺失");
                }
                BigDecimal oneInspPrice = entity.getInspCount().multiply(price);
                inspPrice = inspPrice.add(oneInspPrice);
            }
            inspPrice = inspPrice.multiply(ratio).setScale(2, RoundingMode.DOWN);
            item.setShouldPayAmount(inspPrice);
        }*/
        //key:销售单明细ID value:对应金额
        Map<Long, BigDecimal> map = new HashMap<>();
        if (UocDicConstant.USE_TYPE.PUR.equals(item.getUserType())) {
            //采购方取 销售金额
            uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getSalePrice()));
        } else {
            //平台方取 采购金额
            uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getPurchasePrice()));
        }
        //计算金额
        BigDecimal inspPrice = new BigDecimal("0");
        for (UocInspOrderItem entity : uocInspOrderItemList) {
            //发货数量*金额
            BigDecimal price = map.get(entity.getSaleOrderItemId());
            if (price == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "map数据缺失");
            }
            BigDecimal oneInspPrice = entity.getInspCount().multiply(price);
            inspPrice = inspPrice.add(oneInspPrice);
        }
        inspPrice = inspPrice.multiply(ratio).setScale(2, RoundingMode.DOWN);
        item.setShouldPayAmount(inspPrice);
    }

    /**
     * 计算本条发货单应付金额
     */
    private void fillShipShouldPayFee(UocShouldPayCalculateShouldBO item, UocSaleOrderPayConf payConf, BigDecimal ratio, List<UocShipOrderItem> uocShipOrderItemList, List<UocSaleOrderItem> uocSaleOrderItemList) {
        //！！判断是否为最后一笔发货单
        boolean lastShipOrder = true;
        /*for (UocSaleOrderItem uocSaleOrderItem : uocSaleOrderItemList) {
            if (!(uocSaleOrderItem.getArriveCount().add(uocSaleOrderItem.getRefuseCount())).equals(uocSaleOrderItem.getPurchaseCount())) {
                //存在一条销售单明细不符合（到货数据 + 拒收数量 = 采购数量）的，则不是最后一笔发货单
                lastShipOrder = false;
                break;
            }
        }*/
//        if (lastShipOrder) {
//            //如果为最后一笔， 最后一笔金额 =  总到货款 - 所有生成的发货应付单价格
//            //总到货款
//            BigDecimal verPayFee = payConf.getVerPayFee();
//            //所有生成的发货应付单价格
//            UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
//            uocOrderShouldPay.setOrderId(item.getOrderId());
//            uocOrderShouldPay.setObjectType(item.getObjType());
//
//            //查询该销售单下所有发货单id
//            UocShipOrderQryBo shipOrderQryBo = new UocShipOrderQryBo();
//            shipOrderQryBo.setSaleOrderId(uocSaleOrderItemList.get(0).getSaleOrderId());
//            List<UocShipOrderDo> shipOrderDoList = iUocShipOrderModel.getListShipOrder(shipOrderQryBo);
//            //发货单集合
//            uocOrderShouldPay.setObjectIdList(shipOrderDoList.stream().map(obj -> obj.getShipOrderId()).collect(Collectors.toList()));
//            List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
//            BigDecimal allShipShouldFee = listOrderShouldPay.stream().map(UocOrderShouldPay::getShouldPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
//            item.setShouldPayAmount(verPayFee.subtract(allShipShouldFee));
//        } else {
//            //不是最后一笔
//            //key:销售单明细ID value:对应金额
//            Map<Long, BigDecimal> map = new HashMap<>();
//            if (UocDicConstant.USE_TYPE.PUR.equals(item.getUserType())) {
//                //采购方取 销售金额
//                uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getSalePrice()));
//            } else {
//                //平台方取 采购金额
//                uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getPurchasePrice()));
//            }
//            //计算金额
//            BigDecimal sendPrice = new BigDecimal("0");
//            for (UocShipOrderItem entity : uocShipOrderItemList) {
//                //发货数量*金额
//                BigDecimal price = map.get(entity.getSaleOrderItemId());
//                if (price == null) {
//                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "map数据缺失");
//                }
//                BigDecimal oneSendPrice = entity.getSendCount().multiply(price);
//                sendPrice = sendPrice.add(oneSendPrice);
//            }
//            //乘上对应比例并保留2位小数
//            sendPrice = sendPrice.multiply(ratio).setScale(2, RoundingMode.DOWN);
//            item.setShouldPayAmount(sendPrice);
//        }
        //key:销售单明细ID value:对应金额
        Map<Long, BigDecimal> map = new HashMap<>();
        if (UocDicConstant.USE_TYPE.PUR.equals(item.getUserType())) {
            //采购方取 销售金额
            uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getSalePrice()));
        } else {
            //平台方取 采购金额
            uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getPurchasePrice()));
        }
        //计算金额
        BigDecimal sendPrice = new BigDecimal("0");
        for (UocShipOrderItem entity : uocShipOrderItemList) {
            //发货数量*金额
            BigDecimal price = map.get(entity.getSaleOrderItemId());
            if (price == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "map数据缺失");
            }
            BigDecimal oneSendPrice = entity.getSendCount().multiply(price);
            sendPrice = sendPrice.add(oneSendPrice);
        }
        //乘上对应比例并保留2位小数
        sendPrice = sendPrice.multiply(ratio).setScale(2, RoundingMode.DOWN);
        item.setShouldPayAmount(sendPrice);
        
    }

    /**
     * 查询比例
     * 若销售支付配置中付款方式为‘分阶段’，则根据入参‘应付类型’查询比例,否则返回100%
     */
    private BigDecimal qryRatio(UocShouldPayCalculateReqBO reqBO, UocShouldPayCalculateShouldBO item, UocSaleOrderPayConf payConf) {
        BigDecimal ratio = new BigDecimal("1");
        if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(item.getPayType())) {
            if (UocDicConstant.SHOULD_PAY_TYPE.GOODS.equals(reqBO.getShouldPayType())) {
                ratio = payConf.getVerPaySup().divide(new BigDecimal(100));
            } else if (UocDicConstant.SHOULD_PAY_TYPE.CHECK.equals(reqBO.getShouldPayType())) {
                ratio = payConf.getPilPaySup().divide(new BigDecimal(100));
            } else if (UocDicConstant.SHOULD_PAY_TYPE.GUARANTEE.equals(reqBO.getShouldPayType())) {
                ratio = payConf.getQuaPaySup().divide(new BigDecimal(100));
            }
            else if(UocDicConstant.SHOULD_PAY_TYPE.ADVANCE.equals(reqBO.getShouldPayType())){
                ratio = payConf.getPrePaySup().divide(new BigDecimal(100));
            }
            //else{
            //    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "入参应付类型目前只支持预付款应付、到货款应付、验收款应付、质保金应付");
            //}
        }
        return ratio;
    }

    /**
     * 查询销售单ID
     *
     * @param concurrentHashMap 用于存放事先查询的实体
     * @return 销售单ID
     */
    private Long qrySaleOrderId(UocShouldPayCalculateReqBO reqBO, ConcurrentHashMap<String, Object> concurrentHashMap) {
        Long saleOrderId = null;
        if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
            saleOrderId = reqBO.getObjId();
        } else if (UocDicConstant.OBJ_TYPE.SHIP.equals(reqBO.getObjType())) {
            //从发货单找到销售单ID
            UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
            uocShipOrderQryBo.setShipOrderId(reqBO.getObjId());
            uocShipOrderQryBo.setOrderId(reqBO.getOrderId());
            UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
            if (uocShipOrderDo == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单主体为空");
            }
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
            uocShipOrderItemQryBo.setOrderId(reqBO.getOrderId());
            UocShipOrderDo listShipOrderItem = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            uocShipOrderDo.setShipOrderItemBoList(listShipOrderItem.getShipOrderItemBoList());
            if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单明细为空");
            }
            concurrentHashMap.put("shipOrderDO", uocShipOrderDo);
            concurrentHashMap.put("shipOrderItemDO", uocShipOrderDo.getShipOrderItemBoList());
            saleOrderId = uocShipOrderDo.getSaleOrderId();
        } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(reqBO.getObjType())) {
            //从验收单找到销售单ID
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setOrderId(reqBO.getOrderId());
            uocInspOrderQryBo.setInspOrderId(reqBO.getObjId());
            UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            if (uocInspOrderDo == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询验收单主体为空");
            }
            saleOrderId = uocInspOrderDo.getSaleOrderId();
            //查询验收单明细
            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
            uocInspOrderItemQryBo.setOrderId(reqBO.getOrderId());
            uocInspOrderItemQryBo.setInspOrderId(reqBO.getObjId());
            List<UocInspOrderItem> uocInspOrderItemList = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo).getUocInspOrderItemList();
            if (CollectionUtils.isEmpty(uocInspOrderItemList)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询验收单明细为空");
            }
            concurrentHashMap.put("inspOrderDO", uocInspOrderDo);
            concurrentHashMap.put("inspOrderItemDO", uocInspOrderItemList);
        }
        if (saleOrderId == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单Id为空");
        }
        return saleOrderId;
    }

    /**
     * 填充通用属性
     *
     * @param objType                 入参的单据类型
     * @param shouldPayType           入参的应付类型
     * @param shouldPayList           待填充的应付信息
     * @param uocSaleOrderDo          销售单信息
     * @param stakeholder             三方表信息
     * @param uocSaleOrderPayConfList 销售单支付配置List
     */
    private void fillCommonAttr(Integer objType, Integer shouldPayType, List<UocShouldPayCalculateShouldBO> shouldPayList, UocSaleOrderDo uocSaleOrderDo, UocSaleStakeholder stakeholder, List<UocSaleOrderPayConf> uocSaleOrderPayConfList) {
        for (UocSaleOrderPayConf payConf : uocSaleOrderPayConfList) {
            UocShouldPayCalculateShouldBO uocShouldPayCalculateShouldBO = new UocShouldPayCalculateShouldBO();
            //**返回单据类型（FSC用单据类型）
            if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
                if (UocDicConstant.USE_TYPE.PUR.equals(payConf.getUserType())) {
                    uocShouldPayCalculateShouldBO.setObjectTypeReturn(UocConstant.OBJECT_TYPE.SALE);
                } else {
                    uocShouldPayCalculateShouldBO.setObjectTypeReturn(UocConstant.OBJECT_TYPE.ORDER);
                }
            } else if (UocDicConstant.OBJ_TYPE.SHIP.equals(objType)) {
                uocShouldPayCalculateShouldBO.setObjectTypeReturn(UocConstant.OBJECT_TYPE.GOODS);
            } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(objType)) {
                uocShouldPayCalculateShouldBO.setObjectTypeReturn(UocConstant.OBJECT_TYPE.CHECK);
            }
            //**存储单据类型
            uocShouldPayCalculateShouldBO.setObjectType(objType);
            //**付款方式
            uocShouldPayCalculateShouldBO.setPayType(payConf.getPayType());
            //**应付类型
            uocShouldPayCalculateShouldBO.setShouldPayType(shouldPayType);
            //**订单ID
            uocShouldPayCalculateShouldBO.setOrderId(uocSaleOrderDo.getOrderId());
            //**应付日期(略) 只有账期才有
            if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(payConf.getPayType())) {
                uocShouldPayCalculateShouldBO.setShouldPayDate(this.getShouldPayDate(payConf));
            }
            //**付款方ID、付款方名称、收款方ID、收款方名称
            fillPayerAndPayee(uocSaleOrderDo.getModelSettle(), stakeholder, payConf.getUserType(), uocShouldPayCalculateShouldBO);
            //**合同ID(略)
            //**合同编号(略)
            //**违约金比例
            uocShouldPayCalculateShouldBO.setPenaltyRatio(payConf.getPayBreakScale());
            //**销售单ID
            uocShouldPayCalculateShouldBO.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            /**
             * 后续填充数据使用
             */
            uocShouldPayCalculateShouldBO.setObjType(objType);
            uocShouldPayCalculateShouldBO.setUserType(payConf.getUserType());
            shouldPayList.add(uocShouldPayCalculateShouldBO);
        }
    }

    /**
     * 计算应付日期
     * @param payConf
     * @return
     */
    private Date getShouldPayDate(UocSaleOrderPayConf payConf) {
        Calendar now = Calendar.getInstance();
        //账期支付结算规则 1:指定账期日 2:账期起算特定业务节点+账期天数
        if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
            //指定账期日是每个月固定某一天
            int nowDay = now.get(Calendar.DATE);
            //如果当前日期天数小于指定日期，则返回当前月份的指定日期
            if (nowDay < payConf.getPayAccountDay()) {
                now.set(Calendar.DATE, payConf.getPayAccountDay());
            //如果当前日期天数大于等于指定日期，则返回下一月份的指定日期
            }else {
                now.add(Calendar.MONTH, 1);
                now.set(Calendar.DATE, payConf.getPayAccountDay());
            }
        }else if (UocDicConstant.PAY_RULE.ACCOUNT_PERIOD_COUNT_BUSI_NODE.equals(payConf.getPayRule())) {
            //账期起算特定业务节点+账期天数直接返回当前日期+天数
            now.add(Calendar.DATE, payConf.getPaymentDays());
        }else {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "账期支付结算规则非法！");
        }
        return now.getTime();
    }

    /**
     * 填充付款方ID、付款方名称、收款方ID、收款方名称
     *
     * @param modelSettle                   结算模式
     * @param stakeholder                   三方表信息
     * @param userType                      使用类型
     * @param uocShouldPayCalculateShouldBO 待填充实体
     */
    private void fillPayerAndPayee(Integer modelSettle, UocSaleStakeholder stakeholder, Integer userType, UocShouldPayCalculateShouldBO uocShouldPayCalculateShouldBO) {
        if (UocDicConstant.MODEL_SETTLE.TRADE.equals(modelSettle)) {
            //贸易模式
            if (UocDicConstant.USE_TYPE.PUR.equals(userType)) {
                //采购方
                //付款方取订单三方表采购方机构
                uocShouldPayCalculateShouldBO.setPayerId(Long.valueOf(stakeholder.getPurOrgId()));
                uocShouldPayCalculateShouldBO.setPayerName(stakeholder.getPurOrgName());
                //收款方取订单三方表运营机构
                uocShouldPayCalculateShouldBO.setPayeeId(Long.valueOf(stakeholder.getProId()));
                uocShouldPayCalculateShouldBO.setPayeeName(stakeholder.getProName());
            } else {
                //平台方
                //付款方取订单三方表运营方机构
                uocShouldPayCalculateShouldBO.setPayerId(Long.valueOf(stakeholder.getProId()));
                uocShouldPayCalculateShouldBO.setPayerName(stakeholder.getProName());
                //收款方取订单三方表供应商机构
                uocShouldPayCalculateShouldBO.setPayeeId(Long.valueOf(stakeholder.getSupId()));
                uocShouldPayCalculateShouldBO.setPayeeName(stakeholder.getSupName());
            }
        } else if (UocDicConstant.MODEL_SETTLE.MATCH.equals(modelSettle)) {
            //撮合模式
            //付款方取订单三方表采购方机构
            uocShouldPayCalculateShouldBO.setPayerId(Long.valueOf(stakeholder.getPurOrgId()));
            uocShouldPayCalculateShouldBO.setPayerName(stakeholder.getPurOrgName());
            //收款方取订单三方表供应商机构
            uocShouldPayCalculateShouldBO.setPayeeId(Long.valueOf(stakeholder.getSupId()));
            uocShouldPayCalculateShouldBO.setPayeeName(stakeholder.getSupName());
        }
    }

    /**
     * 查询销售单
     *
     * @param orderId     订单ID
     * @param saleOrderId 销售单ID
     */
    private UocSaleOrderDo qrySaleOrder(Long orderId, Long saleOrderId) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(orderId);
        uocSaleOrderQryBo.setSaleOrderId(saleOrderId);
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "销售单查询为空");
        }
        return uocSaleOrderDo;
    }

    /**
     * 查询销售单支付配置
     * @param orderId     订单ID
     * @param saleOrderId 销售单ID
     * @param shouldPayType
     * @param payNodeRule
     */
    private List<UocSaleOrderPayConf> qrySaleOrderPayConf(Long orderId, Long saleOrderId, Integer shouldPayType, Integer payNodeRule) {
        List<UocSaleOrderPayConf> allSaleOrderPayConfList = new ArrayList<>();
        //如果是预付款应付，则查询要查询分阶段预付款和预付款的支付配置
        if (UocConstant.SHOULD_PAY_TYPE.PRE_PAY.equals(shouldPayType)) {
            UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
            uocSaleOrderPayConfQryBo.setOrderId(orderId);
            uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
            uocSaleOrderPayConfQryBo.setPayType(UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED);
            List<UocSaleOrderPayConf> prePaySaleOrderPayConfList = iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
            if (!CollectionUtils.isEmpty(prePaySaleOrderPayConfList)) {
                allSaleOrderPayConfList.addAll(prePaySaleOrderPayConfList);
            }
            uocSaleOrderPayConfQryBo.setPayType(UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT);
            List<UocSaleOrderPayConf> agrSaleOrderPayConfList = iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
            if (!CollectionUtils.isEmpty(agrSaleOrderPayConfList)) {
                allSaleOrderPayConfList.addAll(agrSaleOrderPayConfList);
            }
//            if (CollectionUtils.isEmpty(allSaleOrderPayConfList)) {
//                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_PAY_CONF_NULL_ERROR, "销售单支付配置查询为空");
//            }
        }else if (UocConstant.SHOULD_PAY_TYPE.ACOUNT_DAY.equals(shouldPayType)) {
            UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
            uocSaleOrderPayConfQryBo.setOrderId(orderId);
            uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
            uocSaleOrderPayConfQryBo.setPayType(UocDicConstant.PAY_TYPE.PAY_BY_PERIOD);
            List<UocSaleOrderPayConf> saleOrderPayConfList = iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
//            if (CollectionUtils.isEmpty(saleOrderPayConfList)) {
//                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_PAY_CONF_NULL_ERROR, "销售单支付配置查询为空");
//            }

            //如果是账期模式，还需要判断是否满足当前节点
            for (UocSaleOrderPayConf bo : saleOrderPayConfList) {
                if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(bo.getPayRule())) {
                    if (payNodeRule.equals(bo.getPayAccountDayRule())) {
                        allSaleOrderPayConfList.add(bo);
                    }
                }else {
                    if (payNodeRule.equals(bo.getPayNodeRule())) {
                        allSaleOrderPayConfList.add(bo);
                    }
                }
            }
        }else {
            UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
            uocSaleOrderPayConfQryBo.setOrderId(orderId);
            uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
            uocSaleOrderPayConfQryBo.setPayType(UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT);
            List<UocSaleOrderPayConf> saleOrderPayConfList = iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
//            if (CollectionUtils.isEmpty(saleOrderPayConfList)) {
//                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_PAY_CONF_NULL_ERROR, "销售单支付配置查询为空");
//            }
            allSaleOrderPayConfList.addAll(saleOrderPayConfList);
        }
        return allSaleOrderPayConfList;
    }


    private void val(UocShouldPayCalculateReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBO.getObjId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象ObjId不能为空");
        }
        if (reqBO.getObjType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象ObjType不能为空");
        }
        if (!UocDicConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())
                && !UocDicConstant.OBJ_TYPE.SHIP.equals(reqBO.getObjType())
                && !UocDicConstant.OBJ_TYPE.INSPECTION.equals(reqBO.getObjType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象ObjType目前仅支持2销售单、4发货单、8验收单");
        }
        if (reqBO.getShouldPayType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象ShouldPayType不能为空");
        }
        if (!UocDicConstant.SHOULD_PAY_TYPE.ADVANCE.equals(reqBO.getShouldPayType())
                && !UocDicConstant.SHOULD_PAY_TYPE.GOODS.equals(reqBO.getShouldPayType())
                && !UocDicConstant.SHOULD_PAY_TYPE.CHECK.equals(reqBO.getShouldPayType())
                && !UocDicConstant.SHOULD_PAY_TYPE.GUARANTEE.equals(reqBO.getShouldPayType())
                && !UocDicConstant.SHOULD_PAY_TYPE.PAYMENT.equals(reqBO.getShouldPayType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象ShouldPayType目前仅支持：1:账期；2：预付款应付；5：到货款应付；6：验收款应付；7：质保金应付");
        }
        if (reqBO.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象OrderId不能为空");
        }
    }
}
