package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocCancelSaleOrderConfirmOrRefuseTransaction
 * 说明:
 * 时间:2023/8/29 14:48
 * 作者:田桂银
 */
@Component
@Slf4j
public class UocCancelSaleOrderConfirmOrRefuseTransaction {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Value("${uoc.cancelSaleOrderConfirmOrRefuse.refuseAgrStatus:XS_FH_DFH}")
    private String refuseAgrStatus;

    @Value("${uoc.cancelSaleOrderConfirmOrRefuse.refuseEsStatus:XS_FH_DFH}")
    private String refuseEsStatus;

    @Value("${uoc.cancelSaleOrderConfirmOrRefuse.refuseNoAgrStatus:XS_FH_DFH}")
    private String refuseNoAgrStatus;

    @Value("${uoc.cancelSaleOrderConfirmOrRefuse.runTask:false}")
    private boolean runTask;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocCancelSaleOrderConfirmOrRefuseRspBo cancelSaleOrderConfirmOrRefuse(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        //更新取消申请变更单信息
        this.updateCancelApplyChangeOrderInfo(reqBo);
        //更新销售单信息
        this.updateSaleOrderInfo(reqBo);
        //如果确认取消申请，则需提交销售单任务
        if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult()) && runTask){
            this.submitTask(reqBo);
        }

        UocCancelSaleOrderConfirmOrRefuseRspBo rspBo = new UocCancelSaleOrderConfirmOrRefuseRspBo();
        buildSyncRsp(reqBo,rspBo);
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }
    /**
     * 构造出参，用于批量数据同步
     */
    private void buildSyncRsp(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo, UocCancelSaleOrderConfirmOrRefuseRspBo rspBo){
        List<String> saleOrderIdList = new ArrayList<>();
        List<String> chngOrderIdList = new ArrayList<>();
        saleOrderIdList.add(reqBo.getSaleOrderId() + "-" + reqBo.getOrderId());
        chngOrderIdList.add(reqBo.getChngOrderId() + "-" + reqBo.getOrderId());
        rspBo.setSaleOrderIdList(saleOrderIdList);
        rspBo.setChngOrderIdList(chngOrderIdList);
    }

    /**
     * 提交销售单任务
     * @param reqBo
     */
    private void submitTask(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo){
        if(ObjectUtil.isNotEmpty(reqBo.getTaskId())){
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            task.setTaskId(reqBo.getTaskId());
            taskInfos.add(task);
            uocCommonDo.setCompleteTaskInfos(taskInfos);
            uocCommonDo.setUserId(reqBo.getUserId());
            uocCommonDo.setOrderId(reqBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }

    }

    /**
     * 更新取消申请变更单信息
     * @param reqBo
     */
    private void updateCancelApplyChangeOrderInfo(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo){
        UocChngOrderDo updateChngOrderDo = new UocChngOrderDo();
        updateChngOrderDo.setChngOrderId(reqBo.getChngOrderId());
        updateChngOrderDo.setOrderId(reqBo.getOrderId());
        if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
            updateChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YQR);
        } else {
            updateChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YJJ);
        }
        updateChngOrderDo.setRejectReason(reqBo.getCancelReplyContent());
        updateChngOrderDo.setRejectTime(new Date());
        updateChngOrderDo.setUpdateOperName(reqBo.getName());
        updateChngOrderDo.setUpdateTime(new Date());
        updateChngOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        this.iUocChngOrderModel.updateChngOrderMain(updateChngOrderDo);
    }
    /**
     * 更新销售单信息
     * @param reqBo
     */
    private void updateSaleOrderInfo(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo){
        UocSaleOrderQryBo qrySale = new UocSaleOrderQryBo();
        qrySale.setOrderId(reqBo.getOrderId());
        qrySale.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(qrySale);
        if (ObjectUtil.isEmpty(uocSaleOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "该销售单单不存在：" + reqBo.getSaleOrderId());
        }
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setCancelReplyContent(reqBo.getCancelReplyContent());
        updateSaleOrderDo.setCancelReplyTime(new Date());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        updateSaleOrderDo.setUpdateTime(new Date());
        updateSaleOrderDo.setCancelTime(new Date());
        if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
            updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QX);
        }else{
//            if(ObjectUtil.isEmpty(reqBo.getOriginalSaleOrderStatus())){
//                if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(uocSaleOrderDo.getOrderSource())) {
//                    updateSaleOrderDo.setSaleOrderState(refuseAgrStatus);
//                } else if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(uocSaleOrderDo.getOrderSource())) {
//                    updateSaleOrderDo.setSaleOrderState(refuseEsStatus);
//                } else if (UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT.equals(uocSaleOrderDo.getOrderSource())) {
//                    updateSaleOrderDo.setSaleOrderState(refuseNoAgrStatus);
//                }
//            }else{
//                updateSaleOrderDo.setSaleOrderState(reqBo.getOriginalSaleOrderStatus());
//            }
            if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(uocSaleOrderDo.getOrderSource())) {
                updateSaleOrderDo.setSaleOrderState(refuseAgrStatus);
            } else if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(uocSaleOrderDo.getOrderSource())) {
                updateSaleOrderDo.setSaleOrderState(refuseEsStatus);
            } else if (UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT.equals(uocSaleOrderDo.getOrderSource())) {
                updateSaleOrderDo.setSaleOrderState(refuseNoAgrStatus);
            }
        }
        this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
        }
        if (null == reqBo.getConfirmResult()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作类型不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getChngOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
    }

}


