package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderStateServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderStateServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * 标题:UocUpdateSaleOrderStateTransaction
 * 说明:
 * 时间:2023/8/30 15:43
 * 作者:田桂银
 */
@Component
public class UocUpdateSaleOrderStateTransaction {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;


    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocUpdateSaleOrderStateServiceRspBo updateSaleOrderState(UocUpdateSaleOrderStateServiceReqBo reqBo) {
        validateArg(reqBo);
        UocUpdateSaleOrderStateServiceRspBo rspBo = UocRu.success(UocUpdateSaleOrderStateServiceRspBo.class);
        //修改状态
        UocSaleOrderDo updateSaleOrderStateDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        updateSaleOrderStateDo.setUpdateOperId(reqBo.getUserId().toString());
        //更新销售单状态
        iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderStateDo);
        return rspBo;
    }

    private void validateArg(UocUpdateSaleOrderStateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocUpdateSaleOrderStateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【用户id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单状态】不能为空");
        }
    }

}


