package com.tydic.dyc.oc.service.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.model.order.impl.OrderModelmpl;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.common.bo.UocQryAccessoryListServiceReqBO;
import com.tydic.dyc.oc.service.common.bo.UocQryAccessoryListServiceRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@HTServiceImpl
public class UocQryAccessoryListServiceImpl implements UocQryAccessoryListService {
    
    @Autowired
    private OrderModelmpl orderModelmpl;
    
    @Override
    public UocQryAccessoryListServiceRspBO qryAccessoryList(UocQryAccessoryListServiceReqBO reqBO) {
        UocQryAccessoryListServiceRspBO rspBO = UocRu.success(UocQryAccessoryListServiceRspBO.class);
        UocOrderAccessoryQryBo accessoryQryBo = JSONObject.parseObject(JSON.toJSONString(reqBO),UocOrderAccessoryQryBo.class);
        List<UocOrderAccessory> accessoryList =  orderModelmpl.getOrderAccessoryList(accessoryQryBo);
        
        rspBO.setAccessoryQryBos(UocRu.jsl(accessoryList, UocBaseOrderAccessoryAddBo.class));
        return rspBO;
    }
}
