package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateShipReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateShipRspBo;
import com.tydic.dyc.oc.transactionservice.UocMsgCreateShipTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/*
 * @Author lsl
 * @Description //TODO 电商订单消息处理，用于生成发货单
 * @Date 16:30 2022/4/12
 * @Param
 * @return
 */
@Slf4j
@HTServiceImpl
public class UocMsgCreateShipServiceImpl implements UocMsgCreateShipService {
    
    @Autowired
    private UocMsgCreateShipTransaction uocMsgCreateShipTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    
    @Override
    public UocMsgCreateShipRspBo createShip(UocMsgCreateShipReqBo reqBo) {
        UocMsgCreateShipRspBo rspBo = uocMsgCreateShipTransaction.createShip(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }
    
    private void syncEs(UocMsgCreateShipReqBo reqBo, UocMsgCreateShipRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
    
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(rspBo.getOrderId());
        saleBo.setObjId(rspBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
    
        SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
        shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
        shipBo.setOrderId(rspBo.getOrderId());
        shipBo.setObjId(rspBo.getShipOrderId());
        shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(shipBo);
        
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
