package com.tydic.dyc.oc.model.implorder;

import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocImplOrder
 * 说明:执行单
 * 时间:2022-02-21 14:29
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocImplOrderDo implements Serializable {
	private static final long serialVersionUID =  2843195778662013062L;


	//销售单id")
	private Long saleOrderId;

	//订单id")
	private Long orderId;

	//执行单编码")
	private String implOrderNo;

	//外部执行单编码")
	private String implOrderNoExt;

	//执行单名称")
	private String implOrderName;

	//执行单类型")
	private Integer implOrderType;

	//执行单类型翻译")
	private String implOrderTypeStr;

	//执行单状态")
	private String implOrderState;

	//执行单状态翻译")
	private String implOrderStateStr;

	//执行单说明")
	private String implOrderDesc;

	//开票标识 0未开票 1已开票")
	private Integer invoiceTag;

	//开票标识翻译")
	private String invoiceTagStr;

	//销售金额")
	private BigDecimal totalSaleFee;

	//采购金额")
	private BigDecimal totalPurchaseFee;

	//优惠金额")
	private BigDecimal totalActShareFee;

	//运费")
	private BigDecimal totalTransFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//协议编号")
	private String agreementNo;

	//合同编号")
	private String contractNo;

	//流转状态")
	private String procState;

	//流转状态翻译")
	private String procStateStr;

	//对账状态")
	private String checkState;

	//对账状态翻译")
	private String checkStateStr;

	//税率")
	private String taxRate;

	//竣工标志 1 竣工 0 在途")
	private Integer finishFlag;

	//竣工标志翻译")
	private String finishFlagStr;

	//租户ID")
	private String tenantId;

	//创建时间")
	private Date createTime;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单 0 未撤单")
	private Integer cancelFlag;

	//撤单标志翻译")
	private String cancelFlagStr;

	//备注")
	private String remark;

	//竣工时间")
	private Date finishTime;

	//逾期时间")
	private Date expTime;

	//结算模式 2:撮合 1:贸易")
	private Integer modelSettle;

	//结算模式翻译")
	private String modelSettleStr;

	//采购类别 1 物资 2 施工 3 服务")
	private Integer purchaseType;

	//采购类别翻译")
	private String purchaseTypeStr;

	//执行单明细")
	private List<UocImplOrderItem> uocImplOrderItemList;

	//执行单纵向扩展")
	private List<UocImplOrderMap> uocImplOrderMapList;

	//执行单明细IDList")
	private List<Long> implOrderItemIdList;

	//订单IDList")
	private List<Long> orderIdList;

}
