package com.tydic.dyc.oc.service.checkorder;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.oc.model.checkorder.UocCheckOrderDo;
import com.tydic.dyc.oc.model.checkorder.UocCheckOrderErrorItemDo;
import com.tydic.dyc.oc.model.checkorder.UocOutCheckOrderModel;
import com.tydic.dyc.oc.service.checkorder.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.List;

@Slf4j
@HTServiceImpl
public class UocCreateCheckOrderServiceImpl implements UocCreateCheckOrderService {
    
    @Autowired
    private UocOutCheckOrderModel uocOutCheckOrderModel;
    
    @Override
    public UocCreateCheckOrderServiceRspBo createCheckOrder(UocCreateCheckOrderServiceReqBo reqBo) {
        UocCreateCheckOrderServiceRspBo rspBo = UocRu.success(UocCreateCheckOrderServiceRspBo.class);
        for(UocCheckOrderBo uocCheckOrderBo : reqBo.getUocCheckOrderBos()){
            UocCheckOrderDo uocCheckOrderDo = UocRu.js(uocCheckOrderBo, UocCheckOrderDo.class);
            uocCheckOrderDo.setCheckDate(DateUtils.strToDate(uocCheckOrderBo.getCheckDate()));
            uocCheckOrderDo.setExecuteTime(DateUtils.strToDate(uocCheckOrderBo.getExecuteTime(),"yyyy-MM-dd HH:mm:ss"));
            uocOutCheckOrderModel.createCheckOrder(uocCheckOrderDo);
            List<UocCheckOrderErrorItemBo> errorItemBos = uocCheckOrderBo.getUocCheckOrderErrorItemBos();
            if(ObjectUtil.isNotEmpty(errorItemBos)){
                for (UocCheckOrderErrorItemBo errorItemBo: errorItemBos){
                    uocOutCheckOrderModel.createCheckOrderErrorItem(UocRu.js(errorItemBo, UocCheckOrderErrorItemDo.class));
                }
            }
        }
        return rspBo;
    }
}
