package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealAfOrderShopAddressReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealAfOrderShopAddressRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

/**
 * 描述：	售后商家收件地址入库
 *
 * @author tkl
 * @date 2022/5/20 14:30
 **/
@HTServiceImpl
public class UocDealAfOrderShopAddressServiceImpl implements UocDealAfOrderShopAddressService {

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    public static final Integer PICKWARE_TYPE = 40;

    @Override
    public UocDealAfOrderShopAddressRspBo dealAfOrderShopAddress(UocDealAfOrderShopAddressReqBo reqBo) {
        UocDealAfOrderShopAddressRspBo rspBo = UocRu.success(UocDealAfOrderShopAddressRspBo.class);
        //入参校验
        boolean pickwareTypeFlag = validataArg(reqBo);
        if (pickwareTypeFlag) return rspBo;
        //查询售后单
        List<UocAfOrder> afOrderList = getAfOrderList(reqBo);
        if (ObjectUtil.isEmpty(afOrderList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "根据服务单ID查询售后单为空");
        }
        Date now = new Date();
        //新增收获信息
        UocOrdLogisticsRela logisticsRela = insertLogisticsRela(reqBo, afOrderList.get(0), now);
        //同步售后关联信息
        updateAfOrderRela(afOrderList.get(0), logisticsRela, now);
        return rspBo;
    }

    private void updateAfOrderRela(UocAfOrder afOrder, UocOrdLogisticsRela logisticsRela, Date now) {
        UocAfOrderDo afOrderDo = new UocAfOrderDo();
        afOrderDo.setAfOrderId(afOrder.getAfOrderId());
        afOrderDo.setExtField1(logisticsRela.getContactId().toString());
        afOrderDo.setUpdateTime(now);
        iUocAfOrderModel.updateAfOrderMain(afOrderDo);
    }

    private List<UocAfOrder> getAfOrderList(UocDealAfOrderShopAddressReqBo reqBo) {
        UocAfOrderQryBo afOrderQryBo = new UocAfOrderQryBo();
        afOrderQryBo.setExtAfId(reqBo.getServiceId());
        return iUocAfOrderModel.getAfOrderList(afOrderQryBo);
    }

    private UocOrdLogisticsRela insertLogisticsRela(UocDealAfOrderShopAddressReqBo reqBo, UocAfOrder afOrder, Date now) {
    
        Long contactId = IdUtil.nextId();
        //更新客户发货时的电商收货地址id
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(afOrder.getAfOrderId());
        uocAfOrderDo.setJhContactId(contactId);
        iUocAfOrderModel.updateAfOrderMain(uocAfOrderDo);
        
        UocOrdLogisticsRela logisticsRela = new UocOrdLogisticsRela();
        logisticsRela.setContactId(contactId);
        logisticsRela.setOrderId(afOrder.getOrderId());
        logisticsRela.setContactAddress(reqBo.getReturnAdress());
        logisticsRela.setContactName(reqBo.getLinkedMan());
        logisticsRela.setContactMobile(reqBo.getLinkedMobile());
        logisticsRela.setCreateTime(now);
        return iUocOrderModel.createOrderLogisticsRela(logisticsRela);
    }

    /**
     * 入参校验
     *
     * @param reqBo
     */
    private boolean validataArg(UocDealAfOrderShopAddressReqBo reqBo) {
        if (ObjectUtil.isNull(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getServiceId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后商家收件地址入库失败：服务单号[serviceId]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPickwareType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后商家收件地址入库失败：寄件方式[pickwareType]不能为空");
        }
        if (ObjectUtil.notEqual(reqBo.getPickwareType(), PICKWARE_TYPE)) {
            return true;
        }
        if (ObjectUtil.equal(reqBo.getPickwareType(), PICKWARE_TYPE) && ObjectUtil.isEmpty(reqBo.getReturnAdress())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后商家收件地址入库失败：寄件方式为客户发货时寄件地址[returnAdress]不能为空");
        }
        return false;
    }
}
