package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetApprovalOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetApprovalOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@HTServiceImpl
public class UocGetApprovalOrderDetailServiceImpl implements UocGetApprovalOrderDetailService {
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Value("${uoc.dataAchiveFlag:false}")
    private Boolean dataAchiveFlag;
    
    /**
     * 审批单详情查询
     *
     * @param reqBo
     * @return
     */
    @Override
    public UocGetApprovalOrderDetailServiceRspBo getApprovalOrderDetail(UocGetApprovalOrderDetailServiceReqBo reqBo) {
        
        //入参校验
        this.validateParam(reqBo);
        UocGetApprovalOrderDetailServiceRspBo rspBo = UocRu.success(UocGetApprovalOrderDetailServiceRspBo.class);
        
        UocAuditOrderQryBo uocAuditOrderQryBo = new UocAuditOrderQryBo();
        uocAuditOrderQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        uocAuditOrderQryBo.setOrderId(reqBo.getOrderId());
        UocAuditOrderDo uocAuditOrderDo = iUocAuditOrderModel.qryAuditOrder(uocAuditOrderQryBo);
        rspBo.setAuditOrderCode(uocAuditOrderDo.getAuditOrderCode());
        rspBo.setAuditOrderId(uocAuditOrderDo.getAuditOrderId());
        
        //1 . 查询该审批单下得所有销售单id
        //查询审批单，订单id+审批单id+审批对象类型（2：销售单）
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        
        log.info("查询uocApprovalObjs：{}", JSON.toJSONString(uocApprovalObjs));
        //销售单id列表
        List<Long> objIdList = uocApprovalObjs.stream().map(e -> {
            return Long.valueOf(e.getObjId());
        }).collect(Collectors.toList());
        
        log.info("查询objIdList：{}", JSON.toJSONString(objIdList));
        
        //查询销售单详情 (只需查询该审批单下得一条销售单信息)
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
//        uocSaleOrderDo.setSaleOrderId(objIdList.get(0));
        List<UocSaleOrderDo> saleOrderMainInfoList = this.iUocSaleOrderModel.qrySaleOrderList(uocSaleOrderDo);
        rspBo.setCreateOrderTime(saleOrderMainInfoList.get(0).getCreateTime());
        rspBo.setSendTime(saleOrderMainInfoList.get(0).getSendTime());
        rspBo.setRemark(saleOrderMainInfoList.get(0).getRemark());
        rspBo.setOrderName(saleOrderMainInfoList.get(0).getSaleOrderName());
        
        //组装三方信息
        if (null != saleOrderMainInfoList.get(0).getStakeholder()) {
            UocGetSaleOrderDetailServiceRspStakeholderBo stakeholderBo = new UocGetSaleOrderDetailServiceRspStakeholderBo();
            BeanUtils.copyProperties(saleOrderMainInfoList.get(0).getStakeholder(), stakeholderBo);
            rspBo.setStakeholderBo(stakeholderBo);
        }
        //如果是协议订单，需要查询协议信息
        Map<String, UocOrderAgreement> orderAgreementMap =null;
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderMainInfoList.get(0).getOrderSource())) {
            UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
            uocOrderAgreementQryBo.setOrderId(reqBo.getOrderId());
            List<UocOrderAgreement> agreementOrderList = this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);

            if (!CollectionUtils.isEmpty(agreementOrderList)) {
           orderAgreementMap = agreementOrderList.stream().collect(Collectors.toMap(UocOrderAgreement::getAgreementId, e -> e));
            }
        }
        //查询附件
        //查询所有附件
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
        uocOrderAccessoryQryBo.setObjId(objIdList.get(0));
        List<UocOrderAccessory> accessoryList = this.iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();

        List<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            List<UocBaseOrderAccessoryDetailBo> accessoryDetailBos = UocRu.jsl(accessoryList, UocBaseOrderAccessoryDetailBo.class);
            Map<Integer, List<UocBaseOrderAccessoryDetailBo>> accessoryDetailMap =
                    accessoryDetailBos.stream().collect(Collectors.groupingBy(UocBaseOrderAccessoryDetailBo::getAttachmentType));
            Iterator<Integer> iterator = accessoryDetailMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer attachmentType = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(attachmentType);
                accessoryTypeDetailBo.setAttchList(UocRu.jsl(accessoryDetailMap.get(attachmentType),UocBaseOrderAccessoryDetailBo.class));
                accessoryDetailBoList.add(accessoryTypeDetailBo);
            }
        }
        log.info("查询附件列表：{}",JSON.toJSONString(accessoryDetailBoList));
        rspBo.setAccessoryList(accessoryDetailBoList);
        
        //查询主订单信息
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo orderInfo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        
        //查询收获人地址信息
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(saleOrderMainInfoList.get(0).getOrderId());
        relaQryBo.setContactId(orderInfo.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        //设置收获人地址信息
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetSaleOrderDetailServiceRspReceiverAddressBo.class));
        
        //查询销售单主体扩展
        List<UocBaseExtParallelBo> uocBaseExtParallelBoList = new ArrayList<>();
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(objIdList.get(0));
        
        List<UocSaleOrderMap> saleOrderExpandList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
            rspBo.setExtFields(JSONArray.parseArray(JSON.toJSONString(saleOrderExpandList), BaseExtendFieldBo.class));
        }
        
        //查询销售单明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderIdList(objIdList);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        log.info("查询审批详情明细：{}", JSON.toJSONString(saleOrderItemList));
        Map<Long, UocSaleOrderDo> uocSaleOrderDoMap = saleOrderMainInfoList.stream().collect(Collectors.toMap(UocSaleOrderDo::getSaleOrderId, e -> e));
        
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            List<UocGetSaleOrderDetailServiceRspItemBo> saleOrderDetailItemBoList = JSONArray.parseArray(JSON.toJSONString(saleOrderItemList)
                    , UocGetSaleOrderDetailServiceRspItemBo.class);
            rspBo.setSaleOrderDetailItemBoList(saleOrderDetailItemBoList);
    
            UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
    
            uocSaleItemMapQryBo.setSaleOrderItemIdList(saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
            List<UocSaleItemMap> saleItemMapList =  iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    
            Map<Long,List<UocSaleItemMap>> saleItemMapMap = saleItemMapList.stream().collect(Collectors.groupingBy(UocSaleItemMap::getSaleOrderItemId));
    
            BigDecimal totalPurchseFee = new BigDecimal("0");
            BigDecimal totalSaleFee = new BigDecimal("0");
            BigDecimal totalTransFee = new BigDecimal("0");
            for (UocGetSaleOrderDetailServiceRspItemBo itemBo : saleOrderDetailItemBoList) {
                itemBo.setSaleOrderNo(uocSaleOrderDoMap.get(itemBo.getSaleOrderId()).getSaleOrderNo());
                itemBo.setSupplierName(uocSaleOrderDoMap.get(itemBo.getSaleOrderId()).getStakeholder().getSupName());
                if (orderAgreementMap!=null){
                    itemBo.setAgreementNo(orderAgreementMap.get(itemBo.getAgreementId()).getPlaAgreementCode());
                    itemBo.setAgreementName(orderAgreementMap.get(itemBo.getAgreementId()).getAgreementName());
                }
                totalPurchseFee = totalPurchseFee.add(itemBo.getPurchaseFee());
                totalSaleFee = totalSaleFee.add(itemBo.getSaleFee());
    
                itemBo.setExtFields(UocRu.jsl(saleItemMapMap.get(itemBo.getSaleOrderItemId()),BaseExtendFieldBo.class));
            }

            rspBo.setTotalSaleFee(totalSaleFee);
            rspBo.setTotalPurchaseFee(totalPurchseFee);
            rspBo.setTotalTransFee(totalTransFee);
        }
        log.info("查询审批详情出参：{}", JSON.toJSONString(rspBo));
        //设置审批流程数据
        //查询审批流程数据
        String dataAchiveTabSuffix = null;
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getAuditProcInst(reqBo, dataAchiveTabSuffix);
        rspBo.setAuditProcInst(auditProcInst);
        
        return rspBo;
    }
    
    private void validateParam(UocGetApprovalOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getAuditOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "审批单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }
    
    
    /**
     * 查询审批流程任务实例
     *
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(UocGetApprovalOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        //查询销售单对应的审批单id
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        
        uocApprovalObjQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (ObjectUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            //查询审批单对应的任务
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            taskInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    uocApprovalObjQryBo1.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocApprovalObj> uocApprovalObjs1 = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (ObjectUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
                procInst.setTaskList(taskBoList);
                //取审批未结束的审批实例Id
                String procInstId = CollectionUtils.isEmpty(uocOrderTaskInsts) ? "" : uocOrderTaskInsts.get(0).getProcInstId();
                if (StringUtils.isNotBlank(procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }
            
        }
        return procInst;
    }
    
}
