/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocQryOrderCreateResultService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspProcessDataBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocQryOrderCreateResultService"})
public class UocQryOrderCreateResultServiceImpl
implements UocQryOrderCreateResultService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @PostMapping(value={"qryOrderCreateResult"})
    public UocQryOrderCreateResultServiceRspBo qryOrderCreateResult(@RequestBody UocQryOrderCreateResultServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocQryOrderCreateResultServiceRspBo rspBo = UocRu.success(UocQryOrderCreateResultServiceRspBo.class);
        UocOrderDo qryOrderDo = new UocOrderDo();
        qryOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo uocOrderDo = this.iUocOrderModel.qryOrderBy(qryOrderDo);
        if (ObjectUtil.isEmpty((Object)((Object)uocOrderDo))) {
            return rspBo;
        }
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setOrderNo(uocOrderDo.getOrderNo());
        rspBo.setTotalSaleFee(uocOrderDo.getTotalSaleFee());
        boolean processResult = true;
        UocSaleOrderDo qrySaleDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        List<UocSaleOrderDo> uocSaleOrderDos = this.iUocSaleOrderModel.qrySaleOrderList(qrySaleDo);
        ArrayList<String> qryDicList = new ArrayList<String>();
        qryDicList.add("UOC_SALE_ORDER_PAY_TYPE");
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(qryDicList);
        for (UocSaleOrderDo uocSaleOrderDo : uocSaleOrderDos) {
            if (!UocConstant.CREATED_RESULT.SUCCESS.equals(uocSaleOrderDo.getCreatedResult())) {
                processResult = false;
            }
            UocQryOrderCreateResultServiceRspProcessDataBo resultDataBo = new UocQryOrderCreateResultServiceRspProcessDataBo();
            if (ObjectUtil.isNotEmpty((Object)uocSaleOrderDo.getCancelReason()) || "XS_QX_QX".equals(uocSaleOrderDo.getSaleOrderState()) || "XS_XD_SB".equals(uocSaleOrderDo.getSaleOrderState()) || !UocConstant.CREATED_RESULT.SUCCESS.equals(uocSaleOrderDo.getCreatedResult()) && !UocConstant.CREATED_RESULT.PROCESSING.equals(uocSaleOrderDo.getCreatedResult())) {
                resultDataBo.setMsg(uocSaleOrderDo.getCancelReason());
                resultDataBo.setResultCode(Integer.valueOf(3));
                resultDataBo.setResultDescription("\u5931\u8d25");
                UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
                saleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
                List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
                resultDataBo.setCommodityInfo(UocRu.jsl(saleOrderItemList, UocGetSaleOrderDetailServiceRspItemBo.class));
                resultDataBo.setSupNo(uocSaleOrderDo.getStakeholder().getSupId());
                rspBo.getFailedList().add(resultDataBo);
            } else {
                resultDataBo.setResultCode(Integer.valueOf(1));
                resultDataBo.setResultDescription("\u6210\u529f");
            }
            UocOrderTaskInst qryTask = new UocOrderTaskInst();
            qryTask.setOrderId(uocSaleOrderDo.getOrderId());
            qryTask.setObjId(uocSaleOrderDo.getSaleOrderId());
            qryTask.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            qryTask.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryTask);
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                Iterator<UocOrderTaskInst> iterator = uocOrderTaskInsts.iterator();
                if (iterator.hasNext()) {
                    UocOrderTaskInst uocOrderTaskInst = iterator.next();
                    List<String> payList = Arrays.asList("N0004", "N0005", "A0007", "A0008", "E0004", "E0003");
                    if (payList.contains(uocOrderTaskInst.getProcState())) {
                        rspBo.getCanPayOrders().add(resultDataBo);
                    } else {
                        rspBo.getNeedApprovedOrders().add(resultDataBo);
                    }
                }
            } else {
                processResult = false;
            }
            resultDataBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            resultDataBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
            resultDataBo.setSupNo(uocSaleOrderDo.getStakeholder().getSupId());
            resultDataBo.setSupName(uocSaleOrderDo.getStakeholder().getSupName());
            resultDataBo.setFee(uocSaleOrderDo.getTotalSaleFee());
            resultDataBo.setPayType(uocSaleOrderDo.getPayType());
            resultDataBo.setPayTypeName(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE") != null ? dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE").get(uocSaleOrderDo.getPayType()) : "");
            resultDataBo.setOrderSource(uocSaleOrderDo.getOrderSource());
            if (UocDicConstant.MODEL_SETTLE.MATCH.equals(uocSaleOrderDo.getModelSettle())) {
                resultDataBo.setSeller(uocSaleOrderDo.getStakeholder().getSupName());
                continue;
            }
            resultDataBo.setSeller(uocSaleOrderDo.getStakeholder().getProName());
        }
        this.searchAuditUrl(rspBo, reqBo);
        rspBo.setProcessResult(Boolean.valueOf(processResult));
        return rspBo;
    }

    private void validateArg(UocQryOrderCreateResultServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocQryOrderCreateResultServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void searchAuditUrl(UocQryOrderCreateResultServiceRspBo rspBO, UocQryOrderCreateResultServiceReqBo reqBo) {
        UocSaleOrderMapQryBo uocSaleItemMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleItemMapQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderMap> saleOrderItemMapList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleItemMapQryBo);
        ArrayList<BaseExtendFieldBo> extFields = new ArrayList<BaseExtendFieldBo>();
        if (!CollectionUtils.isEmpty(saleOrderItemMapList)) {
            for (UocSaleOrderMap uocSaleItemMap : saleOrderItemMapList) {
                if (!uocSaleItemMap.getFieldName().equals("instaceSbumitUrl") && !uocSaleItemMap.getFieldName().equals("instanceQryLogUrl")) continue;
                BaseExtendFieldBo inserBo = new BaseExtendFieldBo();
                inserBo.setFieldValue(uocSaleItemMap.getFieldValue());
                inserBo.setFieldCode(uocSaleItemMap.getFieldCode());
                inserBo.setPrimaryKey(uocSaleItemMap.getSaleOrderId());
                extFields.add(inserBo);
            }
        }
        rspBO.setExtFields(extFields);
    }
}

