/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl.other;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.order.sub.UocConfSupplier;
import com.tydic.dyc.oc.repository.dao.ConfSupplierMapper;
import com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigAbilityReqBo;
import com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigAbilityReqSkuBo;
import com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigAbilityService;
import com.tydic.dyc.oc.service.common.bo.UocProBusinessException;
import com.tydic.dyc.oc.service.common.bo.UocProRspBoUtil;
import com.tydic.dyc.oc.service.common.bo.UocQrySupplierQuotaConfigAbilityRspBo;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigAbilityService"})
public class UocQrySupplierQuotaConfigAbilityServiceImpl
implements UocQrySupplierQuotaConfigAbilityService {
    @Autowired
    private ConfSupplierMapper confSupplierMapper;

    @PostMapping(value={"checkSupQuotaLimit"})
    public UocQrySupplierQuotaConfigAbilityRspBo checkSupQuotaLimit(@RequestBody UocQrySupplierQuotaConfigAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        Set supplierSet = reqBo.getItemList().stream().map(UocQrySupplierQuotaConfigAbilityReqSkuBo::getGoodsSupplierId).collect(Collectors.toSet());
        UocConfSupplier qrySupConfPo = new UocConfSupplier();
        qrySupConfPo.setSupplierNos(new ArrayList(supplierSet));
        List<UocConfSupplier> confSupplierMapperList = this.confSupplierMapper.getList(qrySupConfPo);
        Map<Long, UocConfSupplier> supConfigMap = confSupplierMapperList.stream().collect(Collectors.toMap(UocConfSupplier::getSupNo, obj -> obj));
        Map<Long, List<UocQrySupplierQuotaConfigAbilityReqSkuBo>> supMap = reqBo.getItemList().stream().collect(Collectors.groupingBy(UocQrySupplierQuotaConfigAbilityReqSkuBo::getGoodsSupplierId));
        for (Map.Entry<Long, List<UocQrySupplierQuotaConfigAbilityReqSkuBo>> tMap : supMap.entrySet()) {
            Long key = tMap.getKey();
            List<UocQrySupplierQuotaConfigAbilityReqSkuBo> value = tMap.getValue();
            UocConfSupplier confSupplierPO = supConfigMap.get(key);
            if (confSupplierPO == null) continue;
            BigDecimal totalPrice = new BigDecimal(0);
            for (UocQrySupplierQuotaConfigAbilityReqSkuBo skuBo : value) {
                if (confSupplierPO.getOrderLimit() == null) continue;
                totalPrice = skuBo.getPurchaseCount().multiply(skuBo.getSkuSalePrice()).add(totalPrice);
            }
            try {
                Long aLong = UocMoneyUtil.bigDecimal2Long((BigDecimal)totalPrice);
                if (confSupplierPO.getOrderLimit() <= aLong) continue;
                return (UocQrySupplierQuotaConfigAbilityRspBo)UocProRspBoUtil.failed((String)(confSupplierPO.getSupName() + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3[" + UocMoneyUtil.long2BigDecimal((Long)confSupplierPO.getOrderLimit()).toString() + "]\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002"), UocQrySupplierQuotaConfigAbilityRspBo.class);
            }
            catch (Exception e) {
                throw new UocProBusinessException("104001", "BigDecimal2Long\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
        }
        return (UocQrySupplierQuotaConfigAbilityRspBo)UocProRspBoUtil.success(UocQrySupplierQuotaConfigAbilityRspBo.class);
    }

    private void validateArgs(UocQrySupplierQuotaConfigAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemList = reqBo.getItemList();
        if (ObjectUtil.isEmpty((Object)itemList)) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocQrySupplierQuotaConfigAbilityReqSkuBo tBo : itemList) {
            if (ObjectUtil.isEmpty((Object)tBo)) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getGoodsSupplierId())) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getPurchaseCount())) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getSkuId())) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)tBo.getSkuSalePrice())) continue;
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[skuSalePrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

