package com.tydic.dyc.oc.repository.impl.other;

import cn.hutool.core.util.ObjectUtil;

import com.tydic.dyc.oc.model.order.sub.UocConfSupplier;
import com.tydic.dyc.oc.repository.dao.ConfSupplierMapper;
import com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigAbilityReqBo;
import com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigAbilityReqSkuBo;
import com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigAbilityService;
import com.tydic.dyc.oc.service.common.bo.UocProBusinessException;
import com.tydic.dyc.oc.service.common.bo.UocProRspBoUtil;
import com.tydic.dyc.oc.service.common.bo.UocProRspConstants;
import com.tydic.dyc.oc.service.common.bo.UocQrySupplierQuotaConfigAbilityRspBo;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 描述：根据订单查询供应商限额配置
 *
 * @author tgy
 * @date 2021/6/7 19:12
 */
@HTServiceImpl
public class UocQrySupplierQuotaConfigAbilityServiceImpl implements UocQrySupplierQuotaConfigAbilityService {

    @Autowired
    private ConfSupplierMapper confSupplierMapper;

    @Override
    public UocQrySupplierQuotaConfigAbilityRspBo checkSupQuotaLimit(UocQrySupplierQuotaConfigAbilityReqBo reqBo) {
        validateArgs(reqBo);
        Set<Long> supplierSet = reqBo.getItemList().stream().map(UocQrySupplierQuotaConfigAbilityReqSkuBo::getGoodsSupplierId).collect(Collectors.toSet());
        UocConfSupplier qrySupConfPo = new UocConfSupplier();
        qrySupConfPo.setSupplierNos(new ArrayList<>(supplierSet));
        List<UocConfSupplier> confSupplierMapperList = confSupplierMapper.getList(qrySupConfPo);
        Map<Long, UocConfSupplier> supConfigMap = confSupplierMapperList.stream().collect(Collectors.toMap(UocConfSupplier::getSupNo, obj -> obj));

        //根据供应商分组
        Map<Long, List<UocQrySupplierQuotaConfigAbilityReqSkuBo>> supMap = reqBo.getItemList().stream().collect(Collectors.groupingBy(UocQrySupplierQuotaConfigAbilityReqSkuBo::getGoodsSupplierId));
        for (Map.Entry<Long, List<UocQrySupplierQuotaConfigAbilityReqSkuBo>> tMap : supMap.entrySet()) {
            Long key = tMap.getKey();
            List<UocQrySupplierQuotaConfigAbilityReqSkuBo> value = tMap.getValue();
            UocConfSupplier confSupplierPO = supConfigMap.get(key);
            if (confSupplierPO == null) {
                //如果数据库没配，就不管
                continue;
            }
            BigDecimal totalPrice = new BigDecimal(0);
            for (UocQrySupplierQuotaConfigAbilityReqSkuBo skuBo : value) {
                if (confSupplierPO.getOrderLimit() != null) {
                    totalPrice = skuBo.getPurchaseCount().multiply(skuBo.getSkuSalePrice()).add(totalPrice);
                }
            }

            try {
                Long aLong = UocMoneyUtil.bigDecimal2Long(totalPrice);
                if (confSupplierPO.getOrderLimit() > aLong) {
                    return UocProRspBoUtil.failed(confSupplierPO.getSupName() + "下的订单不满足[" + UocMoneyUtil.long2BigDecimal(confSupplierPO.getOrderLimit()).toString() + "]元，不允许下单。", UocQrySupplierQuotaConfigAbilityRspBo.class);
                }
            } catch (Exception e) {
                throw new UocProBusinessException(UocProRspConstants.RSP_MERGE_CREATE_ORDER_ERROR, "BigDecimal2Long转换异常", e);
            }
        }
        return UocProRspBoUtil.success(UocQrySupplierQuotaConfigAbilityRspBo.class);
    }

    private void validateArgs(UocQrySupplierQuotaConfigAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException(UocProRspConstants.RSP_MERGE_CREATE_ORDER_ERROR, "入参对象不能为空");
        }
        List<UocQrySupplierQuotaConfigAbilityReqSkuBo> itemList = reqBo.getItemList();
        if (ObjectUtil.isEmpty(itemList)) {
            throw new UocProBusinessException(UocProRspConstants.RSP_MERGE_CREATE_ORDER_ERROR, "入参属性itemList不能为空");
        } else {
            for (UocQrySupplierQuotaConfigAbilityReqSkuBo tBo : itemList) {
                if (ObjectUtil.isEmpty(tBo)) {
                    throw new UocProBusinessException(UocProRspConstants.RSP_MERGE_CREATE_ORDER_ERROR, "入参属性itemList中对象不能为空");
                }
                if (ObjectUtil.isEmpty(tBo.getGoodsSupplierId())) {
                    throw new UocProBusinessException(UocProRspConstants.RSP_MERGE_CREATE_ORDER_ERROR, "入参属性itemList中对象属性[goodsSupplierId]不能为空");
                }
                if (ObjectUtil.isEmpty(tBo.getPurchaseCount())) {
                    throw new UocProBusinessException(UocProRspConstants.RSP_MERGE_CREATE_ORDER_ERROR, "入参属性itemList中对象属性[purchaseCount]不能为空");
                }
                if (ObjectUtil.isEmpty(tBo.getSkuId())) {
                    throw new UocProBusinessException(UocProRspConstants.RSP_MERGE_CREATE_ORDER_ERROR, "入参属性itemList中对象属性[skuId]不能为空");
                }
                if (ObjectUtil.isEmpty(tBo.getSkuSalePrice())) {
                    throw new UocProBusinessException(UocProRspConstants.RSP_MERGE_CREATE_ORDER_ERROR, "入参属性itemList中对象属性[skuSalePrice]不能为空");
                }
            }
        }

    }
}


