package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocCmpOrderItemPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocCmpOrderItemMapper
 * 说明:比选明细表
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocCmpOrderItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocCmpOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocCmpOrderItemPo uocCmpOrderItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocCmpOrderItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocCmpOrderItemPo uocCmpOrderItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocCmpOrderItemPo set, @Param("where") UocCmpOrderItemPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocCmpOrderItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocCmpOrderItemPo uocCmpOrderItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocCmpOrderItemPo 参数对象
	 * @return UocCmpOrderItemPo 结果对象
	 */
	UocCmpOrderItemPo getModelBy(UocCmpOrderItemPo uocCmpOrderItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocCmpOrderItemPo 参数对象
	 * @return List<UocCmpOrderItemPo> 结果对象
	 */
	List<UocCmpOrderItemPo> getList(UocCmpOrderItemPo uocCmpOrderItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocCmpOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocCmpOrderItemPo> 结果对象
	 */
	List<UocCmpOrderItemPo> getListPage(UocCmpOrderItemPo uocCmpOrderItemPo, Page<UocCmpOrderItemPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocCmpOrderItemPo> list);

}
