package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrdEvaluatePo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrdEvaluateMapper
 * 说明:评价数据表
 * 时间:2022-04-11 16:47
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrdEvaluateMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrdEvaluatePo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrdEvaluatePo uocOrdEvaluatePo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrdEvaluatePo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrdEvaluatePo uocOrdEvaluatePo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrdEvaluatePo set, @Param("where") UocOrdEvaluatePo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrdEvaluatePo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrdEvaluatePo uocOrdEvaluatePo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrdEvaluatePo 参数对象
	 * @return UocOrdEvaluatePo 结果对象
	 */
	UocOrdEvaluatePo getModelBy(UocOrdEvaluatePo uocOrdEvaluatePo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrdEvaluatePo 参数对象
	 * @return List<UocOrdEvaluatePo> 结果对象
	 */
	List<UocOrdEvaluatePo> getList(UocOrdEvaluatePo uocOrdEvaluatePo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrdEvaluatePo 参数对象
	 * @param page             分页参数
	 * @return List<UocOrdEvaluatePo> 结果对象
	 */
	List<UocOrdEvaluatePo> getListPage(UocOrdEvaluatePo uocOrdEvaluatePo, Page<UocOrdEvaluatePo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrdEvaluatePo> list);

}
