package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocInspOrderItemPo
 * 说明:验收明细
 * 时间:2022-04-01 17:35
 * 作者:罗有
 **/
@Data
public class UocInspOrderItemPo implements Serializable {
	private static final long serialVersionUID = -1226543287368976926L;

	@DocField(value = "验收明细id")
	private Long inspOrderItemId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "销售明细id")
	private Long saleOrderItemId;

	@DocField(value = "发货明细id")
	private Long shipOrderItemId;

	@DocField(value = "验收单id")
	private Long inspOrderId;

	@DocField(value = "状态1 已验收 2 退货申请中             3 退货完成")
	private String inspItemStatus;

	@DocField(value = "计量单位")
	private String unitName;

	@DocField(value = "验收数量")
	private BigDecimal inspCount;

	@DocField(value = "退货中数量")
	private BigDecimal returnCount;

	@DocField(value = "已退货数量")
	private BigDecimal alreadyReturnCount;

	@DocField(value = "异常变更在途数量")
	private BigDecimal chngingCount;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "扩展字段")
	private String extField1;

	@DocField(value = "扩展字段")
	private String extField2;

	@DocField(value = "扩展字段")
	private String extField3;

	@DocField(value = "扩展字段")
	private String extField4;

	@DocField(value = "扩展字段")
	private String extField5;

	@DocField(value = "排序")
	private String orderBy;

	@DocField(value = "销售单idList")
	private List<Long> saleOrderIdList;

	@DocField(value = "验收明细id List")
	private List<Long> inspOrderItemIdList;
}
