package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrderMsgPoolPo
 * 说明:外部消息池表
 * 时间:2022-04-07 12:05
 * 作者:罗有
 **/
@Data
public class UocOrderMsgPoolPo implements Serializable {
	private static final long serialVersionUID = -2779129009624610107L;

	@DocField(value = "ID")
	private Long id;

	private String msgId;

	@DocField(value = "消息类型 1  代表订单拆分变更  2   代表商品价格变更   5 代表该订单已妥投（买断模式代表外单已妥投或外单已拒收 10 代表订单取消（不区分取消原因）")
	private Integer msgType;

	@DocField(value = "消息内容")
	private String msgContent;

	@DocField(value = "状态，1是妥投，2是拒收，3是部分妥投")
	private Integer msgState;

	@DocField(value = "单据ID")
	private Long objId;

	@DocField(value = "单据类型 1订单 2.销售单 3 发货单 4.收货单 5.售后服务单 99.其他")
	private Integer objType;

	@DocField(value = "订单ID")
	private Long orderId;

	@DocField(value = "供货商ID")
	private String supNo;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "消息推送时间")
	private Date pushTime;

	@DocField(value = "消息推送时间 开始")
	private Date pushTimeStart;

	@DocField(value = "消息推送时间 结束")
	private Date pushTimeEnd;

	@DocField(value = "修改时间")
	private Date chngTime;

	@DocField(value = "修改时间 开始")
	private Date chngTimeStart;

	@DocField(value = "修改时间 结束")
	private Date chngTimeEnd;

	@DocField(value = "运行状态  0 失败 成功 2 待处理")
	private Integer runResult;

	@DocField(value = "失败次数")
	private Integer failureCount;

	@DocField(value = "FAILURE_REASON")
	private String failureReason;

	@DocField(value = "外部订单ID")
	private String outOrderId;

	@DocField(value = "订单类型")
	private Integer orderType;

	@DocField(value = "不识别类型记录")
	private String resultString;

	@DocField(value = "发货单号")
	private String packageid;

	@DocField(value = "售后单号")
	private String serviceid;

	@DocField(value = "外部父订单")
	private String pOrderId;

	@DocField(value = "排序")
	private String orderBy;

}
