package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocAfOrderPo
 * 说明:售后服务信息表
 * 时间:2022-04-12 14:37
 * 作者:罗有
 **/
@Data
public class UocAfOrderPo implements Serializable {
	private static final long serialVersionUID = 9063224123190923456L;

	@DocField(value = "售后服务单id")
	private Long afOrderId;

	@DocField(value = "售后服务单编码")
	private String afServCode;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "外部售后服务单号")
	private String extAfId;

	@DocField(value = "外部订单编号")
	private String extOrderId;

	@DocField(value = "服务类型             退货(10)、换货(20)、维修(30)")
	private Integer servType;

	@DocField(value = "服务类型说明")
	private String servTypeDesc;

	@DocField(value = "售后原因")
	private Integer afsReason;

	@DocField(value = "服务方式")
	private Integer serviceWay;

	@DocField(value = "服务方式名称")
	private String serviceWayName;

	@DocField(value = "服务单状态             100提交申请             200 审核中             201审核不通过             300收货完成             400退款成功             401退款失败             500 已完成             600 取消")
	private Integer servState;

	@DocField(value = "未完结状态集合")
	private List<Integer> noCompleteStateList;

	@DocField(value = "是否可取消             0：否             1：是")
	private Integer isCancel;

	@DocField(value = "计量单位")
	private String unitName;

	@DocField(value = "销售退款总金额")
	private BigDecimal retTotalSaleFee;

	@DocField(value = "采购退款总金额")
	private BigDecimal retTotalPurchaseFee;

	@DocField(value = "实际退款金额")
	private BigDecimal realReturnFee;

	@DocField(value = "支付方式             1 预付款             2 电汇或承兑汇票             ")
	private String payType;

	@DocField(value = "支付状态             1退款成功 0 退款失败 null 未处理")
	private Integer payState;

	@DocField(value = "销售时间")
	private Date saleTime;

	@DocField(value = "销售时间 开始")
	private Date saleTimeStart;

	@DocField(value = "销售时间 结束")
	private Date saleTimeEnd;

	@DocField(value = "服务提出时间")
	private Date submiteTime;

	@DocField(value = "服务提出时间 开始")
	private Date submiteTimeStart;

	@DocField(value = "服务提出时间 结束")
	private Date submiteTimeEnd;

	@DocField(value = "服务提出人id")
	private String submitterOperId;

	@DocField(value = "服务提出人名称")
	private String submitterOperName;

	@DocField(value = "服务提出联系人")
	private String subContactName;

	@DocField(value = "服务提出联系人电话")
	private String subContactMobile;

	@DocField(value = "服务提出部门id")
	private String subDeptId;

	@DocField(value = "服务提出部门名称")
	private String subDeptName;

	@DocField(value = "服务提出公司id")
	private String subCompId;

	@DocField(value = "服务提出公司名称")
	private String subCompName;

	@DocField(value = "返件方式             （换、修这两种情况必填）")
	private Integer retMode;

	@DocField(value = "取货服务类型             4：  上门取件             40：客户发货             7：  客户送货")
	private Integer pickwareType;

	@DocField(value = "取货开始时间")
	private Date pickupStartTime;

	@DocField(value = "取货开始时间 开始")
	private Date pickupStartTimeStart;

	@DocField(value = "取货开始时间 结束")
	private Date pickupStartTimeEnd;

	@DocField(value = "取货结束时间")
	private Date pickupEndTime;

	@DocField(value = "取货结束时间 开始")
	private Date pickupEndTimeStart;

	@DocField(value = "取货结束时间 结束")
	private Date pickupEndTimeEnd;

	@DocField(value = "取货联系人id")
	private String pickupContactId;

	@DocField(value = "收货联系人id")
	private String takeContactId;

	@DocField(value = "是否可维护发运信息 1是0否")
	private Integer waybillFlag;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单时间")
	private Date cancelTime2;

	@DocField(value = "撤单时间 开始")
	private Date cancelTime2Start;

	@DocField(value = "撤单时间 结束")
	private Date cancelTime2End;

	@DocField(value = "撤单工号")
	private String cancelOperId2;

	@DocField(value = "撤单原因")
	private String cancelReason2;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "取消人id")
	private String cancelOperId;

	@DocField(value = "取消人名称")
	private String cancelOperName;

	@DocField(value = "取消时间")
	private Date cancelTime;

	@DocField(value = "取消时间 开始")
	private Date cancelTimeStart;

	@DocField(value = "取消时间 结束")
	private Date cancelTimeEnd;

	@DocField(value = "取消类型             1 申请人取消             2 供货商取消")
	private Integer cancelType;

	@DocField(value = "取消原因")
	private String cancelReason;

	@DocField(value = "供应商售后服务环节编码             申请阶段(10)             审核不通过(20)             客服审核(21)             商家审核(22)             京东收货(31)             商家收货(32)             京东处理(33)             商家处理(34)             用户确认(40)             完成(50)             取消 (60)")
	private String serviceStep;

	@DocField(value = "供应商售后服务环节名称")
	private String serviceStepName;

	@DocField(value = "完成时间")
	private Date finishTime;

	@DocField(value = "完成时间 开始")
	private Date finishTimeStart;

	@DocField(value = "完成时间 结束")
	private Date finishTimeEnd;

	@DocField(value = "拒绝/确认备注")
	private String returnReason;

	@DocField(value = "问题描述")
	private String questionDesc;

	@DocField(value = "收货地址ID")
	private Long contactId;

	@DocField(value = "取货地址ID")
	private Long tpContactId;

	@DocField(value = "三方电商换货/回寄维修操作新增订单的ID")
	private String extNewOrderId;

	@DocField(value = "供应商确认时间")
	private Date confirmTime;

	@DocField(value = "供应商确认时间 开始")
	private Date confirmTimeStart;

	@DocField(value = "供应商确认时间 结束")
	private Date confirmTimeEnd;

	@DocField(value = "扩展字段1")
	private String extField1;

	@DocField(value = "扩展字段2")
	private String extField2;

	@DocField(value = "扩展字段3")
	private String extField3;

	@DocField(value = "扩展字段4")
	private String extField4;

	@DocField(value = "扩展字段5")
	private String extField5;

	@DocField(value = "排序")
	private String orderBy;
    
    @DocField(value = "京东售后申请批次号")
    private String thirdApplyId;
}
