package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocOrderPo
 * 说明:订单表
 * 时间:2022-04-11 16:23
 * 作者:罗有
 **/
@Data
public class UocOrderPo implements Serializable {
	private static final long serialVersionUID = -343583979265797397L;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "父订单id")
	private Long upperOrderId;

	@DocField(value = "订单编码")
	private String orderNo;

	@DocField(value = "外部订单编码")
	private String orderNoExt;

	@DocField(value = "订单名称")
	private String orderName;

	@DocField(value = "下单系统")
	private String orderSystem;

	@DocField(value = "订单级别             1 个人订单             2 企业订单")
	private Integer orderLevel;

	@DocField(value = "订单类型 :1.采购电商")
	private Integer orderType;

	@DocField(value = "支付类型")
	private Integer payMod;

	@DocField(value = "支付方式")
	private String payType;

	@DocField(value = "支付状态")
	private String payState;

	@DocField(value = "需要开票标识 0不开票 1需要开票")
	private Integer needInvoiceTag;

	@DocField(value = "订单状态")
	private String orderState;

	@DocField(value = "流转状态")
	private String procState;

	@DocField(value = "订单说明")
	private String orderDesc;

	@DocField(value = "销售金额")
	private BigDecimal totalSaleFee;

	@DocField(value = "采购金额")
	private BigDecimal totalPurchaseFee;

	@DocField(value = "优惠金额")
	private BigDecimal totalActShareFee;

	@DocField(value = "收货地址ID")
	private Long contactId;

	@DocField(value = "运费")
	private BigDecimal totalTransFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "实付积分")
	private BigDecimal usedIntegral;

	@DocField(value = "竣工标志       0 在途         1 竣工          ")
	private Integer finishFlag;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "送货时间")
	private Date sendTime;

	@DocField(value = "送货时间 开始")
	private Date sendTimeStart;

	@DocField(value = "送货时间 结束")
	private Date sendTimeEnd;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "创建人名称")
	private String createOperName;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "更新人名称")
	private String updateOperName;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单时间 开始")
	private Date cancelTimeStart;

	@DocField(value = "撤单时间 结束")
	private Date cancelTimeEnd;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单原因")
	private String cancelReason;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "竣工时间")
	private Date finishTime;

	@DocField(value = "竣工时间 开始")
	private Date finishTimeStart;

	@DocField(value = "竣工时间 结束")
	private Date finishTimeEnd;

	@DocField(value = "逾期时间")
	private Date expTime;

	@DocField(value = "逾期时间 开始")
	private Date expTimeStart;

	@DocField(value = "逾期时间 结束")
	private Date expTimeEnd;

	@DocField(value = "扩展字段1")
	private String extField1;

	@DocField(value = "扩展字段2")
	private String extField2;

	@DocField(value = "扩展字段3")
	private String extField3;

	@DocField(value = "扩展字段4")
	private String extField4;

	@DocField(value = "扩展字段5")
	private String extField5;

	@DocField(value = "扩展字段6")
	private String extField6;

	@DocField(value = "扩展字段7")
	private String extField7;

	@DocField(value = "扩展字段8")
	private String extField8;

	@DocField(value = "扩展字段9")
	private String extField9;

	@DocField(value = "扩展字段10")
	private String extField10;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "排序")
	private String orderBy;

}
