package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.payorder.UocPayOrderDo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderItemObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderMapQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.*;
import com.tydic.dyc.oc.repository.UocPayOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocPayOrderRepositoryImpl
 * 说明:支付单
 * 时间:2022/2/21 18:53
 * 作者:罗有
 */

@Service
public class UocPayOrderRepositoryImpl implements UocPayOrderRepository {

    @Autowired
    private UocPayOrderMapper uocPayOrderMapper;
    @Autowired
    private UocPayOrderMapMapper uocPayOrderMapMapper;
    @Autowired
    private UocPayOrderObjMapper uocPayOrderObjMapper;
    @Autowired
    private UocPayOrderItemObjMapper uocPayOrderItemObjMapper;
    @Autowired
    private UocOrderShouldPayMapper uocOrderShouldPayMapper;

    @Override
    public UocPayOrder getPayOrderMain(UocPayOrderQryBo uocPayOrderQryBo) {
        UocPayOrderPo po = uocPayOrderMapper.getModelBy(UocRu.js(uocPayOrderQryBo, UocPayOrderPo.class));
        return null != po ? UocRu.js(po, UocPayOrder.class) : null;
    }

    @Override
    public List<UocPayOrder> getListPayOrder(UocPayOrderQryBo uocPayOrderQryBo) {
        List<UocPayOrderPo> list = uocPayOrderMapper.getList(UocRu.js(uocPayOrderQryBo, UocPayOrderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocPayOrder.class) : new ArrayList<>();
    }

    @Override
    public List<UocPayOrderObj> getListPayOrderObj(UocPayOrderObjQryBo uocPayOrderObjQryBo) {
        List<UocPayOrderObjPo> list = uocPayOrderObjMapper.getList(UocRu.js(uocPayOrderObjQryBo, UocPayOrderObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocPayOrderObj.class) : new ArrayList<>();
    }

    @Override
    public List<UocPayOrderItemObj> getListPayOrderItemObj(UocPayOrderItemObjQryBo uocPayOrderItemObjQryBo) {
        List<UocPayOrderItemObjPo> list = uocPayOrderItemObjMapper.getList(UocRu.js(uocPayOrderItemObjQryBo, UocPayOrderItemObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocPayOrderItemObj.class) : new ArrayList<>();
    }

    @Override
    public List<UocPayOrderMap> getListPayOrderMap(UocPayOrderMapQryBo uocPayOrderMapQryBo) {
        List<UocPayOrderMapPo> list = uocPayOrderMapMapper.getList(UocRu.js(uocPayOrderMapQryBo, UocPayOrderMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocPayOrderMap.class) : new ArrayList<>();
    }

    @Override
    public void modifyPayOrderMain(UocPayOrderQryBo set,UocPayOrderQryBo where) {
        uocPayOrderMapper.updateBy(UocRu.js(set,UocPayOrderPo.class),UocRu.js(where,UocPayOrderPo.class));
    }

    /**
     * 创建订单应付单
     * @param uocOrderShouldPay
     */
    @Override
    public void createShouldPayOrder(UocOrderShouldPay uocOrderShouldPay) {
        uocOrderShouldPayMapper.insert(UocRu.js(uocOrderShouldPay,UocOrderShouldPayPo.class));
    }

    /**
     * 根据条件获取一条应付单数据
     * @param uocOrderShouldPay 查询条件
     * @return 一条应付单数据
     */
    @Override
    public UocOrderShouldPay getOrderShouldPay(UocOrderShouldPay uocOrderShouldPay) {
        UocOrderShouldPayPo po = uocOrderShouldPayMapper.getModelBy(UocRu.js(uocOrderShouldPay, UocOrderShouldPayPo.class));
        return null != po ? UocRu.js(po, UocOrderShouldPay.class) : null;
    }

    /**
     * 查询多条应付单数据
     *
     * @param uocOrderShouldPay 查询条件
     * @return 多条应付单数据
     */
    @Override
    public List<UocOrderShouldPay> getListOrderShouldPay(UocOrderShouldPay uocOrderShouldPay) {
        List<UocOrderShouldPayPo> list = uocOrderShouldPayMapper.getList(UocRu.js(uocOrderShouldPay, UocOrderShouldPayPo.class));
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : UocRu.jsl(list, UocOrderShouldPay.class);
    }

    /**
     * 订单应付单主体数据更新
     * @param set
     * @param where
     */
    @Override
    public void modifyOrderShouldPayMain(UocOrderShouldPay set, UocOrderShouldPay where) {
        uocOrderShouldPayMapper.updateBy(UocRu.js(set, UocOrderShouldPayPo.class),UocRu.js(where, UocOrderShouldPayPo.class));
    }
}
