package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocSaleItemMapPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocSaleItemMapMapper
 * 说明:销售单明细扩展
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocSaleItemMapMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocSaleItemMapPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocSaleItemMapPo uocSaleItemMapPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocSaleItemMapPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocSaleItemMapPo uocSaleItemMapPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocSaleItemMapPo set, @Param("where") UocSaleItemMapPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocSaleItemMapPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocSaleItemMapPo uocSaleItemMapPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocSaleItemMapPo 参数对象
	 * @return UocSaleItemMapPo 结果对象
	 */
	UocSaleItemMapPo getModelBy(UocSaleItemMapPo uocSaleItemMapPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocSaleItemMapPo 参数对象
	 * @return List<UocSaleItemMapPo> 结果对象
	 */
	List<UocSaleItemMapPo> getList(UocSaleItemMapPo uocSaleItemMapPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocSaleItemMapPo 参数对象
	 * @param page 分页参数
	 * @return List<UocSaleItemMapPo> 结果对象
	 */
	List<UocSaleItemMapPo> getListPage(UocSaleItemMapPo uocSaleItemMapPo, Page<UocSaleItemMapPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocSaleItemMapPo> list);

}
