package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocSaleOrderRepositoryImpl
 * 说明:销售单
 * 时间:2022/2/21 18:54
 * 作者:罗有
 */

@Service
@Slf4j
public class UocSaleOrderRepositoryImpl implements UocSaleOrderRepository {

    @Autowired
    private UocSaleOrderMapper uocSaleOrderMapper;

    @Autowired
    private UocSaleOrderMapMapper uocSaleOrderMapMapper;

    @Autowired
    private UocSaleOrderPayConfMapper uocSaleOrderPayConfMapper;

    @Autowired
    private UocSaleOrderItemMapper uocSaleOrderItemMapper;

    @Autowired
    private UocSaleItemMapMapper uocSaleItemMapMapper;

    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;

    @Autowired
    private UocSaleStakeholderMapper uocSaleStakeholderMapper;

    @Autowired
    private UocOrderRelMapper uocOrderRelMapper;

    @Override
    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {

        //保存销售单
        uocSaleOrderMapper.insert(UocRu.js(saleOrderDo, UocSaleOrderPo.class));

        //保存销售单扩展
        if (ObjectUtil.isNotEmpty(saleOrderDo.getSaleOrderMapList())) {
            uocSaleOrderMapMapper.insertBatch(UocRu.jsl(saleOrderDo.getSaleOrderMapList(), UocSaleOrderMapPo.class));
        }

        //保存支付配置
        if (ObjectUtil.isNotEmpty(saleOrderDo.getSaleOrderPayConfList())) {
            uocSaleOrderPayConfMapper.insertBatch(UocRu.jsl(saleOrderDo.getSaleOrderPayConfList(), UocSaleOrderPayConfPo.class));
        }

        //保存附件
        if (ObjectUtil.isNotEmpty(saleOrderDo.getSaleOrderAccessoryList())) {
            uocOrderAccessoryMapper.insertBatch(UocRu.jsl(saleOrderDo.getSaleOrderAccessoryList(), UocOrderAccessoryPo.class));
        }

        //创建成交服务费关联信息
        if (saleOrderDo.getIsCreateServiceFee()) {
            createServiceFeeRel(saleOrderDo);
        }

        //保存销售明细
        saveSaleItems(saleOrderDo);

        return saleOrderDo;
    }

    private void createServiceFeeRel(UocSaleOrderDo saleOrderDo) {
        UocOrderRelPo uocOrderRelPo = new UocOrderRelPo();
        uocOrderRelPo.setId(IdUtil.nextId());
        uocOrderRelPo.setOrderId(saleOrderDo.getOrderId());
        uocOrderRelPo.setObjId(saleOrderDo.getSaleOrderId());
        uocOrderRelPo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderRelPo.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        uocOrderRelPo.setRelType(UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        uocOrderRelMapper.insert(uocOrderRelPo);
    }

    @Override
    public int modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderPo where = new UocSaleOrderPo();
        where.setOrderId(uocSaleOrderDo.getOrderId());
        where.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());

        UocSaleOrderPo set = UocRu.js(uocSaleOrderDo, UocSaleOrderPo.class);
        set.setSaleOrderId(null);
        set.setOrderId(null);

       return uocSaleOrderMapper.updateBy(set, where);
    }

    @Override
    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo saleOrderDo) {
        UocSaleOrderPo updateSaleSetPo = new UocSaleOrderPo();
        updateSaleSetPo.setSaleOrderState(saleOrderDo.getSaleOrderState());
        updateSaleSetPo.setUpdateTime(new Date());
        //如果环节编码不为空，同步更新
        if (ObjectUtil.isNotEmpty(saleOrderDo.getProcState())) {
            updateSaleSetPo.setProcState(saleOrderDo.getSaleOrderState());
        }
        updateSaleSetPo.setClosePennyDiff(saleOrderDo.getClosePennyDiff());

        UocSaleOrderPo updateSaleWherePo = new UocSaleOrderPo();
        updateSaleWherePo.setOrderId(saleOrderDo.getOrderId());
        updateSaleWherePo.setSaleOrderId(saleOrderDo.getSaleOrderId());

        uocSaleOrderMapper.updateBy(updateSaleSetPo, updateSaleWherePo);
        return saleOrderDo;
    }

    @Override
    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        UocSaleOrderPo qryPo = UocRu.js(qryDo, UocSaleOrderPo.class);
        UocSaleStakeholderPo qryStakeholderPo = new UocSaleStakeholderPo();
        qryStakeholderPo.setOrderId(qryDo.getOrderId());
        List<UocSaleStakeholderPo> list = uocSaleStakeholderMapper.getList(qryStakeholderPo);
        Map<Long, List<UocSaleStakeholderPo>> stakeholderMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(list)) {
            stakeholderMap = list.stream().collect(Collectors.groupingBy(UocSaleStakeholderPo::getStakeholderId));
        }
        List<UocSaleOrderPo> uocSaleOrderPoList = uocSaleOrderMapper.getList(qryPo);
        List<UocSaleOrderDo> retList = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(uocSaleOrderPoList)) {
            retList = UocRu.jsl(uocSaleOrderPoList, UocSaleOrderDo.class);
            for (UocSaleOrderDo uocSaleOrderDo : retList) {
                //设置销售单三方信息
                if (ObjectUtil.isNotEmpty(stakeholderMap) && stakeholderMap.containsKey(uocSaleOrderDo.getStakeholderId())) {
                    uocSaleOrderDo.setStakeholder(UocRu.js(stakeholderMap.get(uocSaleOrderDo.getStakeholderId()).get(0), UocSaleStakeholder.class));
                }
            }
        }
        return retList;
    }

    @Override
    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderDo rspDo = new UocSaleOrderDo();
        UocSaleOrderPo uocSaleOrderPo = uocSaleOrderMapper.getModelBy(UocRu.js(uocSaleOrderDo, UocSaleOrderPo.class));
        if (ObjectUtil.isNotNull(uocSaleOrderPo)) {
            rspDo = UocRu.js(uocSaleOrderPo, UocSaleOrderDo.class);
        }
        return rspDo;
    }


    private void saveSaleItems(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        List<UocSaleItemMapPo> itemMapList = new ArrayList<>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            if (ObjectUtil.isNotEmpty(saleOrderItem.getSaleItemMapList())) {
                itemMapList.addAll(UocRu.jsl(saleOrderItem.getSaleItemMapList(), UocSaleItemMapPo.class));
            }
            if("null".equals(saleOrderItem.getSkuMaterialCode())){
                saleOrderItem.setSkuMaterialCode("");
            }
            if("null".equals(saleOrderItem.getSkuMaterialId())){
                saleOrderItem.setSkuMaterialId("");
            }
            if("null".equals(saleOrderItem.getSkuMaterialTypeId())){
                saleOrderItem.setSkuMaterialTypeId("");
            }
        }
        //保存销售单明细
        uocSaleOrderItemMapper.insertBatch(UocRu.jsl(saleOrderItems, UocSaleOrderItemPo.class));

        //保存销售单明细扩展
        if (ObjectUtil.isNotEmpty(itemMapList)) {
            uocSaleItemMapMapper.insertBatch(itemMapList);
        }

        //保存协议数据

    }


    @Override
    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        //查询销售单主体信息
        UocSaleOrderPo queryUocSaleOrderPo = new UocSaleOrderPo();
        BeanUtils.copyProperties(uocSaleOrderQryBo,queryUocSaleOrderPo);
        UocSaleOrderPo querySaleOrderResultPo = this.uocSaleOrderMapper.getModelBy(queryUocSaleOrderPo);
        if(null != querySaleOrderResultPo){
            UocSaleOrderDo returnSaleOrderResultPo = new UocSaleOrderDo();
            BeanUtils.copyProperties(querySaleOrderResultPo,returnSaleOrderResultPo);
            //查询销售单三方信息
            UocSaleStakeholderPo qryStakeholderPo = new UocSaleStakeholderPo();
            qryStakeholderPo.setOrderId(querySaleOrderResultPo.getOrderId());
            qryStakeholderPo.setStakeholderId(querySaleOrderResultPo.getStakeholderId());
            UocSaleStakeholderPo querySaleStakeholderResultPo =
                    this.uocSaleStakeholderMapper.getModelBy(qryStakeholderPo);
            if (null != querySaleStakeholderResultPo) {
                UocSaleStakeholder returnUocSaleStakeholder = new UocSaleStakeholder();
                BeanUtils.copyProperties(querySaleStakeholderResultPo, returnUocSaleStakeholder);
                returnSaleOrderResultPo.setStakeholder(returnUocSaleStakeholder);
            }
            //查询销售单扩展信息
            UocSaleOrderMapPo saleOrderMapPo = new UocSaleOrderMapPo();
            saleOrderMapPo.setOrderId(querySaleOrderResultPo.getOrderId());
            saleOrderMapPo.setSaleOrderId(querySaleOrderResultPo.getSaleOrderId());
            List<UocSaleOrderMapPo> saleOrderMapPos = uocSaleOrderMapMapper.getList(saleOrderMapPo);
            if (!CollectionUtils.isEmpty(saleOrderMapPos)) {
                List<UocSaleOrderMap> saleOrderMaps = new ArrayList<>(saleOrderMapPos.size());
                for (UocSaleOrderMapPo orderMapPo : saleOrderMapPos) {
                    saleOrderMaps.add(UocRu.js(orderMapPo, UocSaleOrderMap.class));
                }
                returnSaleOrderResultPo.setSaleOrderMapList(saleOrderMaps);
            }
            return returnSaleOrderResultPo;
        }else{
            return null;
        }
    }

    @Override
    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        List<UocOrderAccessoryPo> uocOrderAccessoryPoList = uocOrderAccessoryMapper.getList(UocRu.js(uocOrderAccessoryQryBo, UocOrderAccessoryPo.class));
        if (ObjectUtil.isNotEmpty(uocOrderAccessoryPoList)) {
            uocSaleOrderDo.setSaleOrderAccessoryList(UocRu.jsl(uocOrderAccessoryPoList, UocOrderAccessory.class));
        }
        return uocSaleOrderDo;
    }

    @Override
    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        List<UocSaleOrderPayConfPo> payConfPoList = uocSaleOrderPayConfMapper.getList(UocRu.js(uocSaleOrderPayConfQryBo, UocSaleOrderPayConfPo.class));
        return ObjectUtil.isNotEmpty(payConfPoList) ? UocRu.jsl(payConfPoList, UocSaleOrderPayConf.class) : new ArrayList<>();
    }

    @Override
    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        List<UocSaleOrderMapPo> uocSaleOrderMapPoList = uocSaleOrderMapMapper.getList(UocRu.js(uocSaleOrderMapQryBo, UocSaleOrderMapPo.class));
        return ObjectUtil.isNotEmpty(uocSaleOrderMapPoList) ? UocRu.jsl(uocSaleOrderMapPoList, UocSaleOrderMap.class) : new ArrayList<>();
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPoList = uocSaleOrderItemMapper.getList(UocRu.js(uocSaleOrderItemQryBo, UocSaleOrderItemPo.class));
        List<UocSaleOrderItem> uocSaleOrderItemList = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(uocSaleOrderItemPoList)) {
           /* Map<Long, UocBaseExtCrossBo> uocBaseExtCrossBoMap = new HashMap<>();
            uocSaleOrderItemPoList.forEach(each -> uocBaseExtCrossBoMap.put(each.getSaleOrderItemId(), UocRu.js(each, UocBaseExtCrossBo.class)));*/
            uocSaleOrderItemList = UocRu.jsl(uocSaleOrderItemPoList, UocSaleOrderItem.class);
            /*uocSaleOrderItemList.forEach(each -> {
                if (ObjectUtil.isNotEmpty(uocBaseExtCrossBoMap) && uocBaseExtCrossBoMap.containsKey(each.getSaleOrderItemId())) {
                    each.setExtCrossBo(uocBaseExtCrossBoMap.get(each.getSaleOrderItemId()));
                }
            });*/
        }
        return uocSaleOrderItemList;
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPoList = uocSaleOrderItemMapper.getListByItemIds(itemIds);
        List<UocSaleOrderItem> uocSaleOrderItemList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(uocSaleOrderItemPoList)) {
            uocSaleOrderItemList = UocRu.jsl(uocSaleOrderItemPoList, UocSaleOrderItem.class);
        }
        return uocSaleOrderItemList;
    }

    @Override
    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        List<UocSaleItemMapPo> uocSaleItemMapPoList = uocSaleItemMapMapper.getList(UocRu.js(uocSaleItemMapQryBo, UocSaleItemMapPo.class));
        return ObjectUtil.isNotEmpty(uocSaleItemMapPoList) ? UocRu.jsl(uocSaleItemMapPoList, UocSaleItemMap.class) : new ArrayList<>();
    }


    @Override
    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        List<UocSaleOrderItemPo> uocSaleOrderItemPoList = uocSaleOrderItemMapper.getList(UocRu.js(uocSaleOrderItemQryBo, UocSaleOrderItemPo.class));
        if (ObjectUtil.isNotEmpty(uocSaleOrderItemPoList)) {
            uocSaleOrderDo.setSaleOrderItems(UocRu.jsl(uocSaleOrderItemPoList, UocSaleOrderItem.class));
        }
        return uocSaleOrderDo;
    }

    @Override
    public List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        List<UocSaleStakeholderPo> list = uocSaleStakeholderMapper.getList(UocRu.js(qryBo, UocSaleStakeholderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocSaleStakeholder.class) : new ArrayList<>();
    }

    /**
     * 查询销售单三方信息（单条）
     * @param qryBo
     * @return
     */
    @Override
    public UocSaleStakeholder getSaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        UocSaleStakeholderPo queryUocSaleStakeholderPo = new UocSaleStakeholderPo();
        BeanUtils.copyProperties(qryBo,queryUocSaleStakeholderPo);
        UocSaleStakeholderPo uocSaleStakeholderResultPo = this.uocSaleStakeholderMapper.getModelBy(queryUocSaleStakeholderPo);
        if(null != uocSaleStakeholderResultPo){
            UocSaleStakeholder uocSaleStakeholder = new UocSaleStakeholder();
            BeanUtils.copyProperties(uocSaleStakeholderResultPo,uocSaleStakeholder);
            return uocSaleStakeholder;
        }else{
            return null;
        }
    }

    @Override
    public void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderMapList())) {
            uocSaleOrderMapMapper.insertBatch(UocRu.jsl(uocSaleOrderDo.getSaleOrderMapList(), UocSaleOrderMapPo.class));
        }
    }

    @Override
    public void updateBatchValue(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderMapList())) {
            uocSaleOrderMapMapper.updateBatchValue(UocRu.jsl(uocSaleOrderDo.getSaleOrderMapList(), UocSaleOrderMapPo.class), UocRu.js(uocSaleOrderDo, UocSaleOrderMapPo.class));
        }
    }

    @Override
    public void updateInvalid(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo) {
            uocSaleOrderMapMapper.updateInvalid(UocRu.js(uocSaleOrderDo, UocSaleOrderMapPo.class));
        }
    }

    @Override
    public UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo) {
        UocSaleOrderPo uocSaleOrderPo = uocSaleOrderMapper.qryTotalFeeAndCount(UocRu.js(uocSaleOrderQryBo, UocSaleOrderPo.class));
        return UocRu.js(uocSaleOrderPo, UocSaleOrderDo.class);
    }

    @Override
    public void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo) {
            uocSaleOrderItemMapper.updateBatchItemInspCount(UocRu.jsl(uocSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class), UocRu.js(uocSaleOrderDo, UocSaleOrderItemPo.class));
        }

    }

    @Override
    public void deleteSaleOrder(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo) {
            UocSaleOrderPo where = new UocSaleOrderPo();
            where.setOrderId(uocSaleOrderDo.getOrderId());
            where.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());

            UocSaleOrderPo set = UocRu.js(uocSaleOrderDo, UocSaleOrderPo.class);
            set.setDelTag(UocDicConstant.DELETE_TAG.DELETED);

            uocSaleOrderMapper.updateBy(set, where);
        }
    }

    @Override
    public void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleStakeholderPo where = new UocSaleStakeholderPo();
        where.setOrderId(uocSaleOrderDo.getStakeholder().getOrderId());
        where.setStakeholderId(uocSaleOrderDo.getStakeholder().getStakeholderId());

        UocSaleStakeholderPo set = UocRu.js(uocSaleOrderDo.getStakeholder(), UocSaleStakeholderPo.class);
        uocSaleStakeholderMapper.updateBy(set, where);
    }

    @Override
    public void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem) {
        uocSaleOrderItemMapper.updateItemReturningCount(uocSaleOrderItem);
    }

    @Override
    public void modifyBatchItemSalePrice(UocSaleOrderDo uocSaleOrderDo) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPos = UocRu.jsl(uocSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class);
        uocSaleOrderItemMapper.modifyBatchItemSalePrice(uocSaleOrderItemPos, UocRu.js(uocSaleOrderDo, UocSaleOrderItemPo.class));
    }

    @Override
    public UocSaleOrderDo getSaleItemTotalPrice(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderPo uocSaleOrderPo = UocRu.js(uocSaleOrderDo, UocSaleOrderPo.class);
        UocSaleOrderPo po = uocSaleOrderItemMapper.getSaleItemTotalPrice(uocSaleOrderPo);
        UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
        uocSaleOrderDo1.setTotalSaleFee(po.getTotalSaleFee());
        uocSaleOrderDo1.setTotalPurchaseFee(po.getTotalPurchaseFee());
        return uocSaleOrderDo1;
    }

    @Override
    public void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = UocRu.js(uocSaleOrderDo, UocSaleOrderItemPo.class);
        uocSaleOrderItemMapper.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderItemPo);

    }

    @Override
    public void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        if (null != convertSaleOrderDo) {
            uocSaleOrderItemMapper.updateItemReturnCountZero(UocRu.js(convertSaleOrderDo, UocSaleOrderItem.class));
        }
    }

    @Override
    public void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        if (null != convertSaleOrderDo) {
            uocSaleOrderItemMapper.updateItemReturnCountByChngingCount(UocRu.js(convertSaleOrderDo, UocSaleOrderItem.class));
        }
    }

    @Override
    public void modifyBatchItemChngingCount(UocSaleOrderDo saleOrderDo) {
        uocSaleOrderItemMapper.updateBatchItemChngingCount(UocRu.jsl(saleOrderDo.getSaleOrderItems(), UocSaleOrderItem.class), UocRu.js(saleOrderDo, UocSaleOrderItem.class));
    }


    @Override
    public UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo qryBo) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPos = uocSaleOrderItemMapper.getList(UocRu.js(qryBo, UocSaleOrderItemPo.class));
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderItems(UocRu.jsl(uocSaleOrderItemPos, UocSaleOrderItem.class));
        return uocSaleOrderDo;
    }

    @Override
    public void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo) {
        if (!CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            uocSaleOrderItemMapper.updateBatchItemSendCount(UocRu.jsl(convertSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class), UocRu.js(convertSaleOrderDo, UocSaleOrderItemPo.class));
        }
    }

    @Override
    public void modifyBatchItemArrivalTime(UocSaleOrderDo convertSaleOrderDo) {
        if (!CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            uocSaleOrderItemMapper.updateBatchItemArrivalTime(UocRu.jsl(convertSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class), UocRu.js(convertSaleOrderDo, UocSaleOrderItemPo.class));
        }
    }

    @Override
    public UocSaleOrderDo getCollectCount(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = uocSaleOrderItemMapper.getCollectCount(UocRu.js(uocSaleOrderItemQryBo, UocSaleOrderItemPo.class));
        UocSaleOrderItem uocSaleOrderItem = UocRu.js(uocSaleOrderItemPo, UocSaleOrderItem.class);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderItems(Collections.singletonList(uocSaleOrderItem));
        return uocSaleOrderDo;
    }

    @Override
    public void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem) {
        uocSaleOrderItemMapper.updateSaleOrderItemAfterServingCount(uocSaleOrderItem);
    }

    @Override
    public void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = new UocSaleOrderItemPo();
        uocSaleOrderItemPo.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderItemPo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderItemMapper.modifyInspSuper(uocSaleOrderItemPo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderItemMapper.modifyItemRefuseCountConfirm(UocRu.js(uocSaleOrderDo, UocSaleOrderItem.class));
    }

    @Override
    public void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderItemMapper.modifyItemArriveCountConfirm(UocRu.js(uocSaleOrderDo, UocSaleOrderItem.class));
    }

    @Override
    public int updateItem(UocSaleOrderDo uocSaleOrderDo) {
        int updated = 0;
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            UocSaleOrderItemPo set = new UocSaleOrderItemPo();
            UocSaleOrderItemPo where = new UocSaleOrderItemPo();

            set.setNakedPrice(saleOrderItem.getNakedPrice());
            set.setTax(saleOrderItem.getTax());
            set.setTaxPrice(saleOrderItem.getTaxPrice());

            where.setOrderId(saleOrderItem.getOrderId());
            where.setSaleOrderId(saleOrderItem.getSaleOrderId());
            where.setSkuExtSkuId(saleOrderItem.getSkuExtSkuId());

            int i = uocSaleOrderItemMapper.updateBy(set, where);
            if (i == 1) {
                updated++;
            }
        }
        return updated;
    }

    @Override
    public void updateItemArriveAccount(UocSaleOrderDo uocSaleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            UocSaleOrderItemPo set = new UocSaleOrderItemPo();
            UocSaleOrderItemPo where = new UocSaleOrderItemPo();

            set.setArriveCount(saleOrderItem.getArriveCount());
            set.setRefuseCount(saleOrderItem.getRefuseCount());

            where.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            int i = uocSaleOrderItemMapper.updateBy(set, where);
        }
    }

    @Override
    public void modifyBatchItemPurchasePrice(UocSaleOrderDo uocSaleOrderDo) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPos = UocRu.jsl(uocSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class);
        uocSaleOrderItemMapper.modifyBatchItemPurchasePrice(uocSaleOrderItemPos, UocRu.js(uocSaleOrderDo, UocSaleOrderItemPo.class));
    }

    @Override
    public void modifyItemChngCountRefuse(UocSaleOrderDo saleOrderDo) {
        uocSaleOrderItemMapper.modifyItemChngCountRefuse(UocRu.js(saleOrderDo, UocSaleOrderItem.class));
    }

    @Override
    public void modifyItemChngCountConfirm(UocSaleOrderDo saleOrderDo) {
        uocSaleOrderItemMapper.modifyItemChngCountConfirm(UocRu.js(saleOrderDo, UocSaleOrderItem.class));
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrderList(UocSaleOrderQryBo uocSaleOrderQryBo) {
        UocSaleOrderPo uocSaleOrderPo = UocRu.js(uocSaleOrderQryBo, UocSaleOrderPo.class);
        List<UocSaleOrderPo> uocSaleOrderPoList = uocSaleOrderMapper.getList(uocSaleOrderPo);
        return UocRu.jsl(uocSaleOrderPoList, UocSaleOrderDo.class);
    }

    @Override
     public List<UocSaleOrderDo> cancelEsOrderList(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderPo> uocSaleOrderPoList = uocSaleOrderMapper.cancelEsOrderList(UocRu.js(saleOrderDo, UocSaleOrderPo.class));
        return UocRu.jsl(uocSaleOrderPoList, UocSaleOrderDo.class);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrders(UocSaleOrderQryBo uocSaleOrderQryBo) {
        UocSaleOrderPo uocSaleOrderPo = UocRu.js(uocSaleOrderQryBo, UocSaleOrderPo.class);
        List<UocSaleOrderPo> uocSaleOrderPoList = uocSaleOrderMapper.getSaleOrders(uocSaleOrderPo);
        return UocRu.jsl(uocSaleOrderPoList, UocSaleOrderDo.class);
    }

    @Override
    public int updateSaleOrderPayConfMoney(UocSaleOrderPayConf uocSaleOrderPayConf) {
        UocSaleOrderPayConfPo wherePO = new UocSaleOrderPayConfPo();
        wherePO.setOrderId(uocSaleOrderPayConf.getOrderId());
        wherePO.setSaleOrderId(uocSaleOrderPayConf.getSaleOrderId());
       wherePO.setUserType(uocSaleOrderPayConf.getUserType());
         UocSaleOrderPayConfPo setPO = new UocSaleOrderPayConfPo();
        setPO.setPrePayFee(uocSaleOrderPayConf.getPrePayFee());
        setPO.setVerPayFee(uocSaleOrderPayConf.getVerPayFee());
        setPO.setPilPayFee(uocSaleOrderPayConf.getPilPayFee());
        setPO.setQuaPayFee(uocSaleOrderPayConf.getQuaPayFee());
        return this.uocSaleOrderPayConfMapper.updateBy(setPO, wherePO);
    }
}
