package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.repository.UocSysDictionaryRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocSysDictionaryRepositoryImpl
 * 说明:字典
 * 时间:2022/3/9 14:20
 * 作者:tiankunlin
 */

@Service
@Slf4j
public class UocSysDictionaryRepositoryImpl implements UocSysDictionaryRepository {

    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Value("${crc.sys.tenant.id:305775845729763327}")
    private Long crcSysTenantId;
    @Override
    public List<UocSysDictionaryDo> qryDicList(UocSysDictionaryQryBo reqBO) {
        SysDicDictionaryPo qryPo = UocRu.js(reqBO, SysDicDictionaryPo.class);
        qryPo.setOrderBy(" ORDER_ID ASC");
        List<SysDicDictionaryPo> sysDicDictionaryPoList = sysDicDictionaryMapper.getList(qryPo);
        return ObjectUtil.isNotEmpty(sysDicDictionaryPoList) ? UocRu.jsl(sysDicDictionaryPoList,UocSysDictionaryDo.class) : new ArrayList<>();
    }

    @Override
    public List<UocSysDictionaryDo> qryDicListByPCodes(List<String> pCodes) {
        SysDicDictionaryPo sysDicDictionaryPo = new SysDicDictionaryPo();
        sysDicDictionaryPo.setPCodes(pCodes);
        sysDicDictionaryPo.setSysTenantId(crcSysTenantId);
        List<SysDicDictionaryPo> list = sysDicDictionaryMapper.getList(sysDicDictionaryPo);
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list,UocSysDictionaryDo.class) : new ArrayList<>();
    }

    @Override
    public UocSysDictionaryDo getModelBy(UocSysDictionaryQryBo reqBO) {
        SysDicDictionaryPo sysDicDictionaryPo = sysDicDictionaryMapper.getModelBy(UocRu.js(reqBO, SysDicDictionaryPo.class));
        return ObjectUtil.isNotEmpty(sysDicDictionaryPo) ? UocRu.js(sysDicDictionaryPo,UocSysDictionaryDo.class) : null;
    }

    @Override
    public UocSysDictionaryDo createDic(UocSysDictionaryDo uocSysDictionaryDo) {
        SysDicDictionaryPo sysDicDictionaryPo = UocRu.js(uocSysDictionaryDo, SysDicDictionaryPo.class);
        if (null == sysDicDictionaryPo.getOrderId()) {
            SysDicDictionaryPo qryPo = new SysDicDictionaryPo();
            qryPo.setPCode(sysDicDictionaryPo.getPCode());
            qryPo.setCode(sysDicDictionaryPo.getCode());
            Integer max = sysDicDictionaryMapper.getMaxOrderId(qryPo);
            sysDicDictionaryPo.setOrderId(null == max ? 0 : (max + 1));
        }
        sysDicDictionaryMapper.insert(sysDicDictionaryPo);
        return uocSysDictionaryDo;
    }

    @Override
    public UocSysDictionaryDo updateDic(UocSysDictionaryDo uocSysDictionaryDo) {
        SysDicDictionaryPo where = new SysDicDictionaryPo();
        where.setCode(uocSysDictionaryDo.getCode());
        where.setPCode(uocSysDictionaryDo.getPCode());
        where.setSysTenantId(uocSysDictionaryDo.getSysTenantId());
        sysDicDictionaryMapper.updateBy(UocRu.js(uocSysDictionaryDo,SysDicDictionaryPo.class),where);
        return uocSysDictionaryDo;
    }

    @Override
    public UocSysDictionaryQryBo deleteDic(UocSysDictionaryQryBo reqBO) {
        sysDicDictionaryMapper.deleteBy(UocRu.js(reqBO,SysDicDictionaryPo.class));
        return reqBO;
    }

    @Override
    public List<UocSysDictionaryDo> getModelAmbiguousBy(UocSysDictionaryQryBo uocSysDictionaryQryBo) {
        List<SysDicDictionaryPo> list = sysDicDictionaryMapper.getModelAmbiguousBy(UocRu.js(uocSysDictionaryQryBo, SysDicDictionaryPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list,UocSysDictionaryDo.class) : new ArrayList<>();
    }

    @Override
    public BasePageRspBo<UocSysDictionaryDo> getModelByPage(UocSysDictionaryQryBo reqBO) {
        Page<SysDicDictionaryPo> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<SysDicDictionaryPo> SysDicDictionaryPoList = sysDicDictionaryMapper.getListPage(UocRu.js(reqBO, SysDicDictionaryPo.class), page);
        BasePageRspBo<UocSysDictionaryDo> rspBo = new BasePageRspBo<>();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(UocRu.jsl(SysDicDictionaryPoList, UocSysDictionaryDo.class));
        return rspBo;
    }


}
