package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 标题:UocConfTabOrdStatePo
 * 说明:页面每个sheet页对应的实际订单状态映射规则配置
 * 时间:2022-05-12 22:04
 * 作者:罗有
 **/
@Data
public class UocConfTabOrdStatePo implements Serializable {
	private static final long serialVersionUID = -449029896110076696L;

	@DocField(value = "id")
	private Long id;

	@DocField(value = "tab标签id")
	private Integer tabId;

	@DocField(value = "菜单编码")
	private String menuCode;

	@DocField(value = "菜单编码")
	private String menuPathName;

	@DocField(value = "tab标签名称")
	private String tabName;

	@DocField(value = "排序")
	private Integer sort;

	@DocField(value = "单据类型             1订单             2.销售单             3 发货单             4.收货单             5.售后服务单             6.支付单                          99.其他")
	private Integer objType;

	@DocField(value = "字典编码")
	private String pCode;

	@DocField(value = "环节编码")
	private String orderStatusCode;

	@DocField(value = "环节说明")
	private String orderStatusName;

	@DocField(value = "子环节订单环节编码，逗号分隔")
	private String subOrderStatusCode;

	@DocField(value = "子环节订单环节说明")
	private String subOrderStatusName;

	@DocField(value = "单据状态")
	private String orderStatus;

	@DocField(value = "tab标签idList")
	private List<String> tabIdList;

	@DocField(value = "已办任务环节编码")
	private String doneTacheCode;

	@DocField(value = "订单来源  1 专区 2 电子超市  3 框架协议  4 一单一采 10 店铺下单  20 app下单")
	private String orderSource;

	@DocField(value = "订单来源名称")
	private String orderSourceName;

	@DocField(value = "订单系统")
	private String orderSystem;

	@DocField(value = "订单系统名称")
	private String orderSystemName;

	@DocField(value = "索引名")
	private String indexName;

	@DocField(value = "参数JSON串")
	private String paramJson;

	@DocField(value = "排序")
	private String orderBy;

	@DocField(value = "租户id")
	private Long sysTenantId;

	@DocField(value = "租户名称")
	private String sysTenantName;
}
