package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocCmpOrderMapPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocCmpOrderMapMapper
 * 说明:比选单扩展
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocCmpOrderMapMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocCmpOrderMapPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocCmpOrderMapPo uocCmpOrderMapPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocCmpOrderMapPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocCmpOrderMapPo uocCmpOrderMapPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocCmpOrderMapPo set, @Param("where") UocCmpOrderMapPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocCmpOrderMapPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocCmpOrderMapPo uocCmpOrderMapPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocCmpOrderMapPo 参数对象
	 * @return UocCmpOrderMapPo 结果对象
	 */
	UocCmpOrderMapPo getModelBy(UocCmpOrderMapPo uocCmpOrderMapPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocCmpOrderMapPo 参数对象
	 * @return List<UocCmpOrderMapPo> 结果对象
	 */
	List<UocCmpOrderMapPo> getList(UocCmpOrderMapPo uocCmpOrderMapPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocCmpOrderMapPo 参数对象
	 * @param page 分页参数
	 * @return List<UocCmpOrderMapPo> 结果对象
	 */
	List<UocCmpOrderMapPo> getListPage(UocCmpOrderMapPo uocCmpOrderMapPo, Page<UocCmpOrderMapPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocCmpOrderMapPo> list);

}
