package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocConfAuditPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocConfAuditMapper
 * 说明:uoc_conf_audit
 * 时间:2022-05-19 20:41
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocConfAuditMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocConfAuditPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocConfAuditPo uocConfAuditPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocConfAuditPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocConfAuditPo uocConfAuditPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocConfAuditPo set, @Param("where") UocConfAuditPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocConfAuditPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocConfAuditPo uocConfAuditPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocConfAuditPo 参数对象
	 * @return UocConfAuditPo 结果对象
	 */
	UocConfAuditPo getModelBy(UocConfAuditPo uocConfAuditPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocConfAuditPo 参数对象
	 * @return List<UocConfAuditPo> 结果对象
	 */
	List<UocConfAuditPo> getList(UocConfAuditPo uocConfAuditPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocConfAuditPo 参数对象
	 * @param page           分页参数
	 * @return List<UocConfAuditPo> 结果对象
	 */
	List<UocConfAuditPo> getListPage(UocConfAuditPo uocConfAuditPo, Page<UocConfAuditPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocConfAuditPo> list);

}
