package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocAfOrderObjPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocAfOrderObjMapper
 * 说明:售后服务对象
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocAfOrderObjMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocAfOrderObjPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocAfOrderObjPo uocAfOrderObjPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocAfOrderObjPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocAfOrderObjPo uocAfOrderObjPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocAfOrderObjPo set, @Param("where") UocAfOrderObjPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocAfOrderObjPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocAfOrderObjPo uocAfOrderObjPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocAfOrderObjPo 参数对象
	 * @return UocAfOrderObjPo 结果对象
	 */
	UocAfOrderObjPo getModelBy(UocAfOrderObjPo uocAfOrderObjPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocAfOrderObjPo 参数对象
	 * @return List<UocAfOrderObjPo> 结果对象
	 */
	List<UocAfOrderObjPo> getList(UocAfOrderObjPo uocAfOrderObjPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocAfOrderObjPo 参数对象
	 * @param page 分页参数
	 * @return List<UocAfOrderObjPo> 结果对象
	 */
	List<UocAfOrderObjPo> getListPage(UocAfOrderObjPo uocAfOrderObjPo, Page<UocAfOrderObjPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocAfOrderObjPo> list);

}
