package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocTacheButtonPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocTacheButtonMapper
 * 说明:页面每个sheet页对应的按钮映射规则配置
 * 时间:2022-04-21 15:01
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocTacheButtonMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocTacheButtonPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocTacheButtonPo uocTacheButtonPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocTacheButtonPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocTacheButtonPo uocTacheButtonPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocTacheButtonPo set, @Param("where") UocTacheButtonPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocTacheButtonPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocTacheButtonPo uocTacheButtonPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocTacheButtonPo 参数对象
	 * @return UocTacheButtonPo 结果对象
	 */
	UocTacheButtonPo getModelBy(UocTacheButtonPo uocTacheButtonPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocTacheButtonPo 参数对象
	 * @return List<UocTacheButtonPo> 结果对象
	 */
	List<UocTacheButtonPo> getList(UocTacheButtonPo uocTacheButtonPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocTacheButtonPo 参数对象
	 * @param page             分页参数
	 * @return List<UocTacheButtonPo> 结果对象
	 */
	List<UocTacheButtonPo> getListPage(UocTacheButtonPo uocTacheButtonPo, Page<UocTacheButtonPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocTacheButtonPo> list);

	List<UocTacheButtonPo> getListByTabIdAndTacheCode(UocTacheButtonPo uocTacheButtonPo);
}
