package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrdGoodsPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrdGoodsMapper
 * 说明:订单商品关键信息快照
 * 时间:2022-02-22 16:09
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrdGoodsMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrdGoodsPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrdGoodsPo uocOrdGoodsPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrdGoodsPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrdGoodsPo uocOrdGoodsPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrdGoodsPo set, @Param("where") UocOrdGoodsPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrdGoodsPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrdGoodsPo uocOrdGoodsPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrdGoodsPo 参数对象
	 * @return UocOrdGoodsPo 结果对象
	 */
	UocOrdGoodsPo getModelBy(UocOrdGoodsPo uocOrdGoodsPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrdGoodsPo 参数对象
	 * @return List<UocOrdGoodsPo> 结果对象
	 */
	List<UocOrdGoodsPo> getList(UocOrdGoodsPo uocOrdGoodsPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrdGoodsPo 参数对象
	 * @param page 分页参数
	 * @return List<UocOrdGoodsPo> 结果对象
	 */
	List<UocOrdGoodsPo> getListPage(UocOrdGoodsPo uocOrdGoodsPo, Page<UocOrdGoodsPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrdGoodsPo> list);

}
