/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalLogQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.repository.UocAuditOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocApprovalLogMapper;
import com.tydic.dyc.oc.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.oc.repository.dao.UocAuditOrderMapper;
import com.tydic.dyc.oc.repository.po.UocApprovalLogPo;
import com.tydic.dyc.oc.repository.po.UocApprovalObjPo;
import com.tydic.dyc.oc.repository.po.UocAuditOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocAuditOrderRepositoryImpl
implements UocAuditOrderRepository {
    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private UocApprovalLogMapper uocApprovalLogMapper;

    public UocAuditOrderDo saveAudit(UocAuditOrderDo orderDo) {
        UocAuditOrderPo auditPo = (UocAuditOrderPo)UocRu.js((Object)orderDo, UocAuditOrderPo.class);
        this.uocAuditOrderMapper.insert(auditPo);
        ArrayList<UocApprovalObjPo> poList = new ArrayList<UocApprovalObjPo>();
        List approvalObjs = orderDo.getApprovalObjs();
        for (UocApprovalObj approvalObj : approvalObjs) {
            UocApprovalObjPo po = (UocApprovalObjPo)UocRu.js((Object)approvalObj, UocApprovalObjPo.class);
            po.setAuditOrderId(orderDo.getAuditOrderId());
            po.setSysTenantId(orderDo.getSysTenantId());
            po.setSysTenantName(orderDo.getSysTenantName());
            poList.add(po);
        }
        this.uocApprovalObjMapper.insertBatch(poList);
        if (null != orderDo.getApprovalLog()) {
            UocApprovalLogPo js = (UocApprovalLogPo)UocRu.js((Object)orderDo.getApprovalLog(), UocApprovalLogPo.class);
            js.setSysTenantId(orderDo.getSysTenantId());
            js.setSysTenantName(orderDo.getSysTenantName());
            this.uocApprovalLogMapper.insert(js);
        }
        return orderDo;
    }

    public UocAuditOrderDo updateApprove(UocAuditOrderDo updateDo) {
        UocAuditOrderPo set = (UocAuditOrderPo)UocRu.js((Object)updateDo, UocAuditOrderPo.class);
        UocAuditOrderPo where = new UocAuditOrderPo();
        where.setOrderId(updateDo.getOrderId());
        where.setAuditOrderId(updateDo.getAuditOrderId());
        where.setSysTenantId(updateDo.getSysTenantId());
        this.uocAuditOrderMapper.updateBy(set, where);
        if (null != updateDo.getApprovalLog()) {
            this.uocApprovalLogMapper.insert((UocApprovalLogPo)UocRu.js((Object)updateDo.getApprovalLog(), UocApprovalLogPo.class));
        }
        return updateDo;
    }

    public List<UocApprovalObj> qryApprovealObj(UocApprovalObjQryBo obj) {
        List<UocApprovalObjPo> list = this.uocApprovalObjMapper.getList((UocApprovalObjPo)UocRu.js((Object)obj, UocApprovalObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocApprovalObj.class) : new ArrayList();
    }

    public List<UocAuditOrder> qryAuditOrderList(UocAuditOrderQryBo qryBo) {
        List<UocAuditOrderPo> list = this.uocAuditOrderMapper.getList((UocAuditOrderPo)UocRu.js((Object)qryBo, UocAuditOrderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAuditOrder.class) : new ArrayList();
    }

    public void saveAuditLog(UocAuditOrderDo orderDo) {
        if (null != orderDo && null != orderDo.getApprovalLog()) {
            this.uocApprovalLogMapper.insert((UocApprovalLogPo)UocRu.js((Object)orderDo.getApprovalLog(), UocApprovalLogPo.class));
        }
    }

    public UocAuditOrderDo qryApprovalLog(UocApprovalLogQryBo uocApprovalLogQryBo) {
        UocApprovalLogPo uocApprovalLogPo = new UocApprovalLogPo();
        uocApprovalLogPo.setAuditOrderId(uocApprovalLogQryBo.getAuditOrderId());
        uocApprovalLogPo.setSysTenantId(uocApprovalLogQryBo.getSysTenantId());
        List<UocApprovalLogPo> uocApprovalLogPos = this.uocApprovalLogMapper.getList(uocApprovalLogPo);
        UocAuditOrderDo uocAuditOrderDo = new UocAuditOrderDo();
        List uocApprovalLogs = UocRu.jsl(uocApprovalLogPos, UocApprovalLog.class);
        uocAuditOrderDo.setUocApprovalLogList(uocApprovalLogs);
        return uocAuditOrderDo;
    }

    public UocAuditOrderDo qryAuditOrder(UocAuditOrderQryBo qryBo) {
        UocAuditOrderPo modelBy = this.uocAuditOrderMapper.getModelBy((UocAuditOrderPo)UocRu.js((Object)qryBo, UocAuditOrderPo.class));
        return (UocAuditOrderDo)UocRu.js((Object)modelBy, UocAuditOrderDo.class);
    }
}

