package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrderBusiOperRecordPo
 * 说明:订单业务操作记录表
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
public class UocOrderBusiOperRecordPo implements Serializable {
	private static final long serialVersionUID =  6299413773382151061L;

	private Long id;

	@DocField(value = "记录类型                          1、流程操作记录：                1）、task_id,task_name填写uoc_ord_task中对应task_id,task_name                2）、oper_type_id填写uoc_ord_task中tache_code             2、单据操作记录：                1）、task_id,task_name不填                2）、oper_type_id填写定义的枚举值（数据字典:task_deal_code）,oper_type_id填写枚举值对应的中文说明                                          ")
	private Integer recordType;

	@DocField(value = "单据id      单据类型为1=订单时，不填")
	private Long objId;

	@DocField(value = "单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "切面流水")
	private String secSn;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "处理时间")
	private Date dealTime;

	@DocField(value = "处理时间 开始")
	private Date dealTimeStart;

	@DocField(value = "处理时间 结束")
	private Date dealTimeEnd;

	@DocField(value = "处理工号")
	private String dealOperId;

	@DocField(value = "处理人名称")
	private String dealOperName;

	@DocField(value = "处理人角色")
	private String dealRole;

	@DocField(value = "处理人部门id")
	private String dealDeptId;

	@DocField(value = "处理人部门")
	private String dealDeptName;

	@DocField(value = "处理人公司id")
	private String dealCompId;

	@DocField(value = "处理人公司")
	private String dealCompName;

	@DocField(value = "流程任务id")
	private String taskId;

	@DocField(value = "流程任务名称")
	private String taskName;

	@DocField(value = "处理类型id                          见数据字典：task_deal_type")
	private String dealTypeId;

	@DocField(value = "处理类型名称")
	private String dealTypeName;

	@DocField(value = "处理动作编码                          见数据字典：task_deal_code")
	private String dealCode;

	@DocField(value = "处理动作名称")
	private String dealName;

	@DocField(value = "处理原因                          见数据字典：task_deal_reason")
	private String dealReason;

	@DocField(value = "处理描述")
	private String dealDesc;

	@DocField(value = "处理人岗位ID")
	private String dealPostId;

	@DocField(value = "处理人岗位名称")
	private String dealPostName;

	@DocField(value = "主机ip地址")
	private String ipAddress;

	@DocField(value = "订单编号")
	private String orderNo;

		@DocField(value = "排序")
	private String orderBy;

	@DocField(value = "租户id")
	private Long sysTenantId;

	@DocField(value = "租户名称")
	private String sysTenantName;

}
