package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.waitdone.UocWaitDoneConfigDo;
import com.tydic.dyc.oc.model.waitdone.qrybo.UocWaitDoneConfigQryBo;
import com.tydic.dyc.oc.repository.UocWaitDoneRepository;
import com.tydic.dyc.oc.repository.dao.UocWaitDoneConfigMapper;
import com.tydic.dyc.oc.repository.po.UocWaitDoneConfigPo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：类名称:UocWaitDoneRepositoryImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/5/19 19:24
 * 作者 @author 尹栋梁
 */
@Service
@Slf4j
public class UocWaitDoneRepositoryImpl implements UocWaitDoneRepository {
    @Autowired
    private UocWaitDoneConfigMapper waitDoneConfigMapper;
    @Override
    public List<UocWaitDoneConfigDo> qryWaitDoneList(UocWaitDoneConfigQryBo uocWaitDoneConfigQryBo) {
        UocWaitDoneConfigPo waitDoneConfigPo = UocRu.js(uocWaitDoneConfigQryBo, UocWaitDoneConfigPo.class);
        List<UocWaitDoneConfigPo> waitDoneConfigPoList = waitDoneConfigMapper.getList(waitDoneConfigPo);
        return ObjectUtil.isNotEmpty(waitDoneConfigPoList) ? UocRu.jsl(waitDoneConfigPoList, UocWaitDoneConfigDo.class) : new ArrayList<>();
    }
}
