package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.CfcParamConfigPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:CfcParamConfigMapper
 * 说明:业务参数
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface CfcParamConfigMapper {

	/**
	 * 插入单条数据
	 *
	 * @param cfcParamConfigPo 参数对象
	 * @return int 影响数量
	 */
	int insert(CfcParamConfigPo cfcParamConfigPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param cfcParamConfigPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(CfcParamConfigPo cfcParamConfigPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") CfcParamConfigPo set, @Param("where") CfcParamConfigPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param cfcParamConfigPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(CfcParamConfigPo cfcParamConfigPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param cfcParamConfigPo 参数对象
	 * @return CfcParamConfigPo 结果对象
	 */
	CfcParamConfigPo getModelBy(CfcParamConfigPo cfcParamConfigPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param cfcParamConfigPo 参数对象
	 * @return List<CfcParamConfigPo> 结果对象
	 */
	List<CfcParamConfigPo> getList(CfcParamConfigPo cfcParamConfigPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param cfcParamConfigPo 参数对象
	 * @param page 分页参数
	 * @return List<CfcParamConfigPo> 结果对象
	 */
	List<CfcParamConfigPo> getListPage(CfcParamConfigPo cfcParamConfigPo, Page<CfcParamConfigPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<CfcParamConfigPo> list);

}
