package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocAfOrderWaybillPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocAfOrderWaybillMapper
 * 说明:售后服务运单信息
 * 时间:2022-03-31 15:30
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocAfOrderWaybillMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocAfOrderWaybillPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocAfOrderWaybillPo uocAfOrderWaybillPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocAfOrderWaybillPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocAfOrderWaybillPo uocAfOrderWaybillPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocAfOrderWaybillPo set, @Param("where") UocAfOrderWaybillPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocAfOrderWaybillPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocAfOrderWaybillPo uocAfOrderWaybillPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocAfOrderWaybillPo 参数对象
	 * @return UocAfOrderWaybillPo 结果对象
	 */
	UocAfOrderWaybillPo getModelBy(UocAfOrderWaybillPo uocAfOrderWaybillPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocAfOrderWaybillPo 参数对象
	 * @return List<UocAfOrderWaybillPo> 结果对象
	 */
	List<UocAfOrderWaybillPo> getList(UocAfOrderWaybillPo uocAfOrderWaybillPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocAfOrderWaybillPo 参数对象
	 * @param page                分页参数
	 * @return List<UocAfOrderWaybillPo> 结果对象
	 */
	List<UocAfOrderWaybillPo> getListPage(UocAfOrderWaybillPo uocAfOrderWaybillPo, Page<UocAfOrderWaybillPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocAfOrderWaybillPo> list);

}
