package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderProcInstPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderProcInstMapper
 * 说明:订单流程实例
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderProcInstMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderProcInstPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderProcInstPo uocOrderProcInstPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderProcInstPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderProcInstPo uocOrderProcInstPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderProcInstPo set, @Param("where") UocOrderProcInstPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderProcInstPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderProcInstPo uocOrderProcInstPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderProcInstPo 参数对象
	 * @return UocOrderProcInstPo 结果对象
	 */
	UocOrderProcInstPo getModelBy(UocOrderProcInstPo uocOrderProcInstPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderProcInstPo 参数对象
	 * @return List<UocOrderProcInstPo> 结果对象
	 */
	List<UocOrderProcInstPo> getList(UocOrderProcInstPo uocOrderProcInstPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderProcInstPo 参数对象
	 * @param page 分页参数
	 * @return List<UocOrderProcInstPo> 结果对象
	 */
	List<UocOrderProcInstPo> getListPage(UocOrderProcInstPo uocOrderProcInstPo, Page<UocOrderProcInstPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderProcInstPo> list);

}
